/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.attribute.AttributePredicates;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.embedded.impl.IdentifierMap;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.util.TimedOperation;
import com.atlassian.crowd.util.TimedProgressOperation;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheRefresher.class);
    protected final RemoteDirectory remoteDirectory;

    public AbstractCacheRefresher(RemoteDirectory remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    protected static <T extends Group> List<T> filterOutDuplicateGroups(List<T> remoteGroups) {
        LinkedHashMap groupMap = Maps.newLinkedHashMap();
        HashSet badGroups = Sets.newHashSet();
        for (Group ldapGroup : remoteGroups) {
            Group origGroup;
            String groupId = IdentifierUtils.toLowerCase((String)ldapGroup.getName());
            if (badGroups.contains(groupId) || (origGroup = groupMap.put(groupId, ldapGroup)) == null) continue;
            groupMap.remove(groupId);
            badGroups.add(groupId);
            if (!origGroup.getName().equals(ldapGroup.getName())) {
                log.warn("group [{}] duplicated in remote directory by group [{}]. Ignoring group.", (Object)origGroup.getName(), (Object)ldapGroup.getName());
                continue;
            }
            log.warn("group [{}] duplicated in remote directory. Ignoring group.", (Object)origGroup.getName());
        }
        return badGroups.isEmpty() ? remoteGroups : ImmutableList.copyOf(groupMap.values());
    }

    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        this.synchroniseAllUsers(directoryCache);
        List<? extends Group> allGroups = this.synchroniseAllGroups(directoryCache);
        TimedOperation groupAttributeSyncOperation = new TimedOperation();
        this.synchroniseAllGroupAttributes(allGroups, directoryCache);
        log.debug(groupAttributeSyncOperation.complete("finished group attribute sync"));
        this.synchroniseMemberships(allGroups, directoryCache);
    }

    protected abstract void synchroniseAllUsers(DirectoryCache var1) throws OperationFailedException;

    protected abstract List<? extends Group> synchroniseAllGroups(DirectoryCache var1) throws OperationFailedException;

    Iterable<Membership> getMemberships(Iterable<String> names) throws OperationFailedException {
        return this.remoteDirectory.getMemberships();
    }

    protected void synchroniseAllGroupAttributes(List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        for (Group group : remoteGroups) {
            if (!(group instanceof GroupWithAttributes)) continue;
            try {
                GroupWithAttributes remoteGroupWithAttributes = (GroupWithAttributes)group;
                GroupWithAttributes internalGroupWithAttributes = directoryCache.findGroupWithAttributesByName(remoteGroupWithAttributes.getName());
                Set<String> attributesToDelete = this.getAttributesToDelete((Attributes)remoteGroupWithAttributes, (Attributes)internalGroupWithAttributes);
                Map<String, Set<String>> attributesToStore = this.getAttributesToStore((Attributes)remoteGroupWithAttributes, (Attributes)internalGroupWithAttributes);
                directoryCache.applySyncingGroupAttributes(group.getName(), attributesToDelete, attributesToStore);
            }
            catch (GroupNotFoundException e) {
                throw new OperationFailedException("Failed to synchronize directory group attributes for missing group: " + group.getName());
            }
        }
    }

    protected Set<String> getAttributesToDelete(Attributes newAttributes, Attributes oldAttributes) {
        HashSet<String> attributesToDelete = new HashSet<String>();
        for (String key : Iterables.filter((Iterable)oldAttributes.getKeys(), (Predicate)AttributePredicates.SYNCING_ATTRIBUTE)) {
            if (newAttributes.getKeys().contains(key)) continue;
            attributesToDelete.add(key);
        }
        return attributesToDelete;
    }

    protected Map<String, Set<String>> getAttributesToStore(Attributes newAttributes, Attributes oldAttributes) {
        HashMap<String, Set<String>> attributesToStore = new HashMap<String, Set<String>>();
        for (String key : Iterables.filter((Iterable)newAttributes.getKeys(), (Predicate)AttributePredicates.SYNCING_ATTRIBUTE)) {
            if (Objects.equal((Object)newAttributes.getValues(key), (Object)oldAttributes.getValues(key))) continue;
            attributesToStore.put(key, newAttributes.getValues(key));
        }
        return attributesToStore;
    }

    protected void synchroniseMemberships(List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        if (log.isDebugEnabled()) {
            log.debug("Updating memberships for " + remoteGroups.size() + " groups from " + this.directoryDescription());
        }
        int total = remoteGroups.size();
        IdentifierMap groupsByName = new IdentifierMap();
        for (Group group : remoteGroups) {
            String name = group.getName();
            if (null == groupsByName.put(name, group)) continue;
            throw new OperationFailedException("Unable to synchronise directory: duplicate groups with name '" + name + "'");
        }
        TimedProgressOperation operation = new TimedProgressOperation("migrated memberships for group", total, log);
        TimedOperation timedOperation = new TimedOperation();
        Iterable<Membership> memberships = this.getMemberships(groupsByName.keySet());
        log.debug(timedOperation.complete("Got remote memberships"));
        Iterator<Membership> iter = memberships.iterator();
        TimedOperation applyMembershipsOperation = new TimedOperation();
        while (iter.hasNext()) {
            long start = System.currentTimeMillis();
            Membership membership = iter.next();
            long finish = System.currentTimeMillis();
            long duration = finish - start;
            log.debug("found [ " + membership.getUserNames().size() + " ] remote user-group memberships, " + "[ " + membership.getChildGroupNames().size() + " ] remote group-group memberships in [ " + duration + "ms ]");
            Group g = (Group)groupsByName.get(membership.getGroupName());
            if (g == null) {
                log.debug("Unexpected group in response: " + membership.getGroupName());
                continue;
            }
            directoryCache.syncUserMembersForGroup(g, membership.getUserNames());
            if (this.remoteDirectory.supportsNestedGroups()) {
                directoryCache.syncGroupMembersForGroup(g, membership.getChildGroupNames());
            }
            operation.incrementedProgress();
        }
        log.debug(applyMembershipsOperation.complete("Applied remote memberships"));
    }

    protected boolean isIncrementalSyncEnabled() {
        return Boolean.parseBoolean(this.remoteDirectory.getValue("crowd.sync.incremental.enabled"));
    }

    @Nullable
    protected String getCqlUserFilter() {
        String filterFromSysProp = System.getProperty("com.atlassian.crowd.sync.user.filter.cql");
        if (filterFromSysProp != null) {
            return filterFromSysProp;
        }
        String filterFromDirProp = this.remoteDirectory.getValue("com.atlassian.crowd.sync.user.filter.cql");
        if (filterFromDirProp != null) {
            log.warn("User filter set to {} via directory attribute; this should not be set in production", (Object)filterFromDirProp);
            return filterFromDirProp;
        }
        return null;
    }

    protected String directoryDescription() {
        return this.remoteDirectory.getDescriptiveName() + " Directory " + this.remoteDirectory.getDirectoryId();
    }
}

