/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.name.Converter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;

public class GenericConverter
implements Converter {
    @Override
    public LdapName getName(String dn) throws InvalidNameException {
        try {
            return new LdapName(dn);
        }
        catch (IllegalArgumentException e) {
            throw (InvalidNameException)new InvalidNameException("Cannot convert <" + dn + "> to a LDAP name").initCause(e);
        }
    }

    @Override
    public LdapName getName(String attributeName, String objectName, LdapName baseDN) throws InvalidNameException {
        List<Object> rdns = baseDN != null ? baseDN.getRdns() : Collections.emptyList();
        ArrayList<Rdn> newRdns = new ArrayList<Rdn>(rdns);
        newRdns.add(new Rdn(attributeName, objectName));
        return new LdapName(newRdns);
    }

    public static LdapName emptyLdapName() {
        return new LdapName(Collections.<Rdn>emptyList());
    }
}

