/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.RFC4519DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.LDAPEntityNameMap;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UsnChangedCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(UsnChangedCacheRefresher.class);
    private static final long UNINITIALISED = -1L;
    public static final Function<Tombstone, String> TOMBSTONE_TO_GUID_FUNCTION = new Function<Tombstone, String>(){

        public String apply(Tombstone tombstone) {
            return tombstone.getObjectGUID();
        }
    };
    private final MicrosoftActiveDirectory activeDirectory;
    private volatile long highestCommittedUSN = -1L;
    private final LDAPEntityNameMap<LDAPUserWithAttributes> userMap = new LDAPEntityNameMap();
    private final LDAPEntityNameMap<LDAPGroupWithAttributes> groupMap = new LDAPEntityNameMap();
    private Future<List<LDAPUserWithAttributes>> userListFuture;
    private Future<List<LDAPGroupWithAttributes>> groupListFuture;

    public UsnChangedCacheRefresher(MicrosoftActiveDirectory activeDirectory) {
        super(activeDirectory);
        this.activeDirectory = activeDirectory;
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        if (this.highestCommittedUSN == -1L || !this.isIncrementalSyncEnabled()) {
            return false;
        }
        if (this.getCqlUserFilter() != null) {
            throw new OperationFailedException("Incremental sync with a configured CQL user filter is not supported");
        }
        long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
        this.synchroniseUserChanges(directoryCache);
        this.synchroniseGroupChanges(directoryCache);
        this.highestCommittedUSN = currentHighestCommittedUSN;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        ExecutorService queryExecutor = Executors.newFixedThreadPool(3, ThreadFactories.namedThreadFactory((String)"CrowdUsnChangedCacheRefresher"));
        try {
            this.userListFuture = queryExecutor.submit(new Callable<List<LDAPUserWithAttributes>>(){

                @Override
                public List<LDAPUserWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug("loading remote users");
                    List<LDAPUserWithAttributes> ldapUsers = UsnChangedCacheRefresher.this.activeDirectory.searchUsers(QueryBuilder.queryFor(LDAPUserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
                    log.info("found [ " + ldapUsers.size() + " ] remote users in [ " + (System.currentTimeMillis() - start) + "ms ]");
                    return ldapUsers;
                }
            });
            this.groupListFuture = queryExecutor.submit(new Callable<List<LDAPGroupWithAttributes>>(){

                @Override
                public List<LDAPGroupWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug("loading remote groups");
                    List<LDAPGroupWithAttributes> ldapGroups = UsnChangedCacheRefresher.this.activeDirectory.searchGroups(QueryBuilder.queryFor(LDAPGroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
                    log.info("found [ " + ldapGroups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
                    return ldapGroups;
                }
            });
            long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
            super.synchroniseAll(directoryCache);
            this.highestCommittedUSN = currentHighestCommittedUSN;
        }
        finally {
            queryExecutor.shutdown();
            this.userListFuture = null;
            this.groupListFuture = null;
        }
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        this.userMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPUserWithAttributes> ldapUsers = this.userListFuture.get();
            for (LDAPUserWithAttributes ldapUser : ldapUsers) {
                this.userMap.put(ldapUser);
            }
            directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
            directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(DirectoryCache directoryCache) throws OperationFailedException {
        this.groupMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPGroupWithAttributes> ldapGroups = this.groupListFuture.get();
            ldapGroups = Collections.unmodifiableList(UsnChangedCacheRefresher.filterOutDuplicateGroups(ldapGroups));
            for (LDAPGroupWithAttributes ldapGroup : ldapGroups) {
                this.groupMap.put(ldapGroup);
            }
            directoryCache.addOrUpdateCachedGroups(ldapGroups, syncStartDate);
            directoryCache.deleteCachedGroupsNotIn(GroupType.GROUP, ldapGroups, syncStartDate);
            return ldapGroups;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void synchroniseUserChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote users");
        List<LDAPUserWithAttributes> updatedUsers = this.activeDirectory.findAddedOrUpdatedUsersSince(this.highestCommittedUSN);
        List<Tombstone> tombstones = this.activeDirectory.findUserTombstonesSince(this.highestCommittedUSN);
        log.info("found [ " + (updatedUsers.size() + tombstones.size()) + " ] changed remote users in [ " + (System.currentTimeMillis() - start) + "ms ]");
        for (LDAPUserWithAttributes updatedUser : updatedUsers) {
            this.userMap.put(updatedUser);
        }
        start = System.currentTimeMillis();
        ImmutableSet tombstonesGuids = ImmutableSet.copyOf((Iterable)Iterables.transform(tombstones, TOMBSTONE_TO_GUID_FUNCTION));
        log.info("scanned and compared [ " + tombstones.size() + " ] users for delete in DB cache in [ " + (System.currentTimeMillis() - start) + "ms ]");
        directoryCache.deleteCachedUsersByGuid((Set<String>)tombstonesGuids);
        directoryCache.addOrUpdateCachedUsers(updatedUsers, null);
    }

    private void synchroniseGroupChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug("loading changed remote groups");
        List<LDAPGroupWithAttributes> updatedGroups = UsnChangedCacheRefresher.filterOutDuplicateGroups(this.activeDirectory.findAddedOrUpdatedGroupsSince(this.highestCommittedUSN));
        List<Tombstone> tombstones = this.activeDirectory.findGroupTombstonesSince(this.highestCommittedUSN);
        log.info("found [ " + (updatedGroups.size() + tombstones.size()) + " ] changed remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]");
        for (LDAPGroupWithAttributes group : updatedGroups) {
            this.groupMap.put(group);
        }
        directoryCache.addOrUpdateCachedGroups(updatedGroups, null);
        this.synchroniseMemberships(updatedGroups, directoryCache);
        start = System.currentTimeMillis();
        HashSet<String> groupnames = new HashSet<String>();
        for (Tombstone tombstone : tombstones) {
            String groupName = this.groupMap.getByGuid(tombstone.getObjectGUID());
            if (groupName == null) continue;
            groupnames.add(groupName);
        }
        log.info("scanned and compared [ " + tombstones.size() + " ] groups for delete in DB cache in [ " + (System.currentTimeMillis() - start) + "ms ]");
        directoryCache.deleteCachedGroups(groupnames);
    }

    @Override
    Iterable<Membership> getMemberships(Iterable<String> names) throws OperationFailedException {
        try {
            Map<LdapName, String> users = this.userMap.toLdapNameKeyedMap();
            Map<LdapName, String> groups = this.groupMap.toLdapNameKeyedMap();
            return new RFC4519DirectoryMembershipsIterable(this.activeDirectory, users, groups, (Set<String>)ImmutableSet.copyOf(names));
        }
        catch (InvalidNameException e) {
            throw new OperationFailedException("Failed to get directory memberships due to invalid DN", (Throwable)e);
        }
    }
}

