/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.event.api.EventPublisher;
import com.google.common.base.Preconditions;
import javax.naming.directory.Attributes;

public class NovelleDirectory
extends RFC4519Directory {
    private final PasswordHelper passwordHelper;

    public NovelleDirectory(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordHelper passwordHelper) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
        this.passwordHelper = (PasswordHelper)Preconditions.checkNotNull((Object)passwordHelper);
    }

    public static String getStaticDirectoryType() {
        return "Novell eDirectory Server";
    }

    public String getDescriptiveName() {
        return NovelleDirectory.getStaticDirectoryType();
    }

    @Override
    protected String encodePassword(PasswordCredential passwordCredential) throws InvalidCredentialException {
        if (PasswordCredential.NONE.equals((Object)passwordCredential)) {
            return this.passwordHelper.generateRandomPassword();
        }
        if (passwordCredential.isEncryptedCredential()) {
            throw new InvalidCredentialException("Password credential must not be encrypted before being encoded");
        }
        return passwordCredential.getCredential();
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, user.getName());
    }
}

