/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.util;

import com.atlassian.crowd.directory.ldap.util.GuidHelper;
import com.atlassian.crowd.directory.ldap.util.XmlValidator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.ldap.UncategorizedLdapException;

public class DirectoryAttributeRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryAttributeRetriever.class);

    public static String getValueFromAttributes(String directoryAttributeName, Attributes directoryAttributes) {
        if (StringUtils.isBlank((CharSequence)directoryAttributeName)) {
            return null;
        }
        String value = null;
        Attribute values = directoryAttributes.get(directoryAttributeName);
        if (values != null && values.size() > 0) {
            try {
                Object attributeValue = values.get(0);
                if (attributeValue != null && (StringUtils.isBlank((CharSequence)(value = attributeValue.toString())) || !XmlValidator.isSafe(value))) {
                    String currentLdapContext = MDC.get((String)"crowd.ldap.context");
                    String ldapContextMessage = currentLdapContext != null ? "Context: <" + currentLdapContext + ">. " : "";
                    logger.info("Unsafe or Blank attribute value <" + value + "> for attribute <" + directoryAttributeName + ">. " + ldapContextMessage + "Attribute was skipped.");
                    value = null;
                }
            }
            catch (NamingException e) {
                throw new UncategorizedLdapException((Throwable)e);
            }
        }
        return value;
    }

    public static String getValueFromExternalIdAttribute(String externalIdAttribute, Attributes directoryAttributes) {
        if (StringUtils.isBlank((CharSequence)externalIdAttribute)) {
            return null;
        }
        Attribute values = directoryAttributes.get(externalIdAttribute);
        if (values == null || values.size() == 0) {
            return "";
        }
        try {
            Object attributeValue = values.get(0);
            if (attributeValue instanceof String) {
                return attributeValue.toString();
            }
            if (attributeValue != null) {
                return GuidHelper.getGUIDAsString((byte[])values.get());
            }
            return "";
        }
        catch (NamingException e) {
            throw new UncategorizedLdapException((Throwable)e);
        }
    }
}

