/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Membership;
import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.naming.ldap.LdapName;

public class RFC4519DirectoryMembershipsIterable
implements Iterable<Membership> {
    private final RFC4519Directory connector;
    private final Map<LdapName, String> users;
    private final Map<LdapName, String> groups;
    private Function<? super Map.Entry<LdapName, String>, ? extends Membership> lookUpMembers = new Function<Map.Entry<LdapName, String>, Membership>(){

        public Membership apply(Map.Entry<LdapName, String> input) {
            Iterable<LdapName> directMembers;
            try {
                directMembers = RFC4519DirectoryMembershipsIterable.this.connector.findDirectMembersOfGroup(input.getKey());
            }
            catch (OperationFailedException e) {
                throw new Membership.MembershipIterationException((Throwable)e);
            }
            final String groupName = input.getValue();
            final HashSet userNames = new HashSet();
            final HashSet childGroupNames = new HashSet();
            for (LdapName member : directMembers) {
                if (RFC4519DirectoryMembershipsIterable.this.users.containsKey(member)) {
                    userNames.add(RFC4519DirectoryMembershipsIterable.this.users.get(member));
                }
                if (!RFC4519DirectoryMembershipsIterable.this.groups.containsKey(member)) continue;
                childGroupNames.add(RFC4519DirectoryMembershipsIterable.this.groups.get(member));
            }
            return new Membership(){

                public String getGroupName() {
                    return groupName;
                }

                public Set<String> getUserNames() {
                    return userNames;
                }

                public Set<String> getChildGroupNames() {
                    return childGroupNames;
                }
            };
        }
    };

    public RFC4519DirectoryMembershipsIterable(RFC4519Directory springLDAPConnector, Map<LdapName, String> users, Map<LdapName, String> groups) {
        this.connector = springLDAPConnector;
        this.users = users;
        this.groups = groups;
    }

    @Override
    public Iterator<Membership> iterator() {
        return Iterators.transform(this.groups.entrySet().iterator(), this.lookUpMembers);
    }
}

