/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.util;

import com.atlassian.crowd.directory.ldap.util.XmlValidator;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.UncategorizedLdapException;

public class DirectoryAttributeRetriever {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryAttributeRetriever.class);

    public static String getValueFromAttributes(String directoryAttributeName, Attributes directoryAttributes) {
        if (StringUtils.isBlank((String)directoryAttributeName)) {
            return null;
        }
        String value = null;
        Attribute values = directoryAttributes.get(directoryAttributeName);
        if (values != null && values.size() > 0) {
            try {
                Object attributeValue = values.get(0);
                if (attributeValue != null && (StringUtils.isBlank((String)(value = attributeValue.toString())) || !XmlValidator.isSafe(value))) {
                    logger.info("Unsafe or Blank attribute value for attribute <" + directoryAttributeName + ">: '" + value + "'.");
                    value = null;
                }
            }
            catch (NamingException e) {
                throw new UncategorizedLdapException((Throwable)e);
            }
        }
        return value;
    }
}

