/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.name.Converter;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchDN {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final LDAPPropertiesMapper propertiesMapper;
    private final Converter converter;

    public SearchDN(LDAPPropertiesMapper propertiesMapper, Converter converter) {
        this.propertiesMapper = propertiesMapper;
        this.converter = converter;
    }

    public Name getGroup() {
        try {
            return this.getSearchDN("ldap.group.dn");
        }
        catch (InvalidNameException e) {
            this.logger.error("Group Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getRole() {
        try {
            return this.getSearchDN("ldap.role.dn");
        }
        catch (InvalidNameException e) {
            this.logger.error("Role Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getUser() {
        try {
            return this.getSearchDN("ldap.user.dn");
        }
        catch (InvalidNameException e) {
            this.logger.error("User Search DN could not be parsed", (Throwable)e);
            return new CompositeName();
        }
    }

    public Name getBase() throws InvalidNameException {
        return this.converter.getName(this.propertiesMapper.getAttribute("ldap.basedn"));
    }

    public Name getNamingContext() {
        Name baseDN;
        try {
            baseDN = this.getBase();
        }
        catch (InvalidNameException e) {
            baseDN = new CompositeName();
        }
        return baseDN;
    }

    protected Name getSearchDN(String propertyName) throws InvalidNameException {
        String searchDN = "";
        String additionalDN = this.propertiesMapper.getAttribute(propertyName);
        if (StringUtils.isNotBlank((String)additionalDN)) {
            searchDN = additionalDN + ",";
        }
        searchDN = searchDN + this.propertiesMapper.getAttribute("ldap.basedn");
        return this.converter.getName(searchDN);
    }
}

