/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.entity.LDAPGroupAttributesMapper;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.atlassian.crowd.model.group.GroupTemplateWithAttributes;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import java.util.List;
import javax.naming.directory.Attributes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DistinguishedName;

public class GroupContextMapper
implements ContextMapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final long directoryId;
    protected final GroupType groupType;
    protected final LDAPPropertiesMapper ldapPropertiesMapper;
    protected final List<AttributeMapper> customAttributeMappers;

    public GroupContextMapper(long directoryId, GroupType groupType, LDAPPropertiesMapper ldapPropertiesMapper, List<AttributeMapper> customAttributeMappers) {
        this.directoryId = directoryId;
        this.groupType = groupType;
        this.ldapPropertiesMapper = ldapPropertiesMapper;
        this.customAttributeMappers = customAttributeMappers;
    }

    public Object mapFromContext(Object ctx) throws NamingException {
        DirContextAdapter context = (DirContextAdapter)ctx;
        Attributes attributes = context.getAttributes();
        LDAPGroupAttributesMapper mapper = this.getAttributesMapper();
        GroupTemplateWithAttributes groupTemplate = mapper.mapGroupFromAttributes(attributes);
        for (AttributeMapper attributeMapper : this.customAttributeMappers) {
            try {
                groupTemplate.setAttribute(attributeMapper.getKey(), attributeMapper.getValues(context));
            }
            catch (Exception e) {
                this.logger.error("Failed to map attribute <" + attributeMapper.getKey() + "> from context with DN <" + context.getDn().toString() + ">", (Throwable)e);
            }
        }
        String dn = DNStandardiser.standardise((DistinguishedName)context.getDn(), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        LDAPGroupWithAttributes group = new LDAPGroupWithAttributes(dn, groupTemplate);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Created group <" + group + "> from DN <" + context.getDn() + ">");
        }
        return group;
    }

    protected LDAPGroupAttributesMapper getAttributesMapper() {
        return new LDAPGroupAttributesMapper(this.directoryId, this.groupType, this.ldapPropertiesMapper);
    }
}

