/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.AttributeValuesHolder;
import com.atlassian.crowd.directory.DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.LDAPDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapperImpl;
import com.atlassian.crowd.directory.ldap.LdapTemplateWithClassLoaderWrapper;
import com.atlassian.crowd.directory.ldap.mapper.GroupContextMapper;
import com.atlassian.crowd.directory.ldap.mapper.UserContextMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.entity.LDAPGroupAttributesMapper;
import com.atlassian.crowd.directory.ldap.mapper.entity.LDAPUserAttributesMapper;
import com.atlassian.crowd.directory.ldap.name.Converter;
import com.atlassian.crowd.directory.ldap.name.Encoder;
import com.atlassian.crowd.directory.ldap.name.GenericConverter;
import com.atlassian.crowd.directory.ldap.name.GenericEncoder;
import com.atlassian.crowd.directory.ldap.name.SearchDN;
import com.atlassian.crowd.directory.ldap.util.DNStandardiser;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.LDAPDirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.ldap.LDAPQuery;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.ldap.NullResultException;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.GroupQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.crowd.util.UserUtils;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ldap.NameNotFoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.control.PagedResultsDirContextProcessor;
import org.springframework.ldap.core.CollectingNameClassPairCallbackHandler;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.ContextMapperCallbackHandler;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.DirContextProcessor;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.support.AggregateDirContextProcessor;
import org.springframework.ldap.core.support.LdapContextSource;
import org.springframework.ldap.transaction.compensating.manager.ContextSourceTransactionManager;
import org.springframework.ldap.transaction.compensating.manager.TransactionAwareContextSourceProxy;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;

public abstract class SpringLDAPConnector
implements LDAPDirectory {
    public static final int DEFAULT_PAGE_SIZE = 999;
    private static final Logger logger = LoggerFactory.getLogger(SpringLDAPConnector.class);
    private volatile long directoryId;
    protected volatile AttributeValuesHolder attributes;
    protected volatile LdapTemplateWithClassLoaderWrapper ldapTemplate;
    protected volatile ContextSource contextSource;
    protected volatile Converter nameConverter;
    protected volatile SearchDN searchDN;
    protected volatile LDAPPropertiesMapper ldapPropertiesMapper;
    protected volatile ContextSourceTransactionManager contextSourceTransactionManager;
    protected final LDAPQueryTranslater ldapQueryTranslater;
    protected final EventPublisher eventPublisher;
    private final InstanceFactory instanceFactory;

    public SpringLDAPConnector(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        this.ldapQueryTranslater = ldapQueryTranslater;
        this.eventPublisher = eventPublisher;
        this.instanceFactory = instanceFactory;
    }

    public long getDirectoryId() {
        return this.directoryId;
    }

    public void setDirectoryId(long id) {
        this.directoryId = id;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = new AttributeValuesHolder(attributes);
        Object object = this.instanceFactory.getInstance(LDAPPropertiesMapperImpl.class);
        this.ldapPropertiesMapper = (LDAPPropertiesMapper)object;
        this.ldapPropertiesMapper.setAttributes(attributes);
        this.contextSource = SpringLDAPConnector.createContextSource(this.ldapPropertiesMapper, this.getBaseEnvironmentProperties());
        this.contextSourceTransactionManager = new ContextSourceTransactionManager();
        this.contextSourceTransactionManager.setContextSource(this.contextSource);
        this.ldapTemplate = new LdapTemplateWithClassLoaderWrapper(new LdapTemplate(this.contextSource));
        if (!this.ldapPropertiesMapper.isReferral()) {
            this.ldapTemplate.setIgnorePartialResultException(true);
        }
        this.nameConverter = new GenericConverter(this.getEncoder());
        this.searchDN = new SearchDN(this.ldapPropertiesMapper, this.nameConverter);
    }

    private static ContextSource createContextSource(LDAPPropertiesMapper ldapPropertiesMapper, Map<String, String> envProperties) {
        LdapContextSource targetContextSource = new LdapContextSource();
        targetContextSource.setUrl(ldapPropertiesMapper.getConnectionURL());
        targetContextSource.setUserDn(ldapPropertiesMapper.getUsername());
        targetContextSource.setPassword(ldapPropertiesMapper.getPassword());
        targetContextSource.setBaseEnvironmentProperties(envProperties);
        targetContextSource.setPooled(true);
        try {
            targetContextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return new TransactionAwareContextSourceProxy((ContextSource)targetContextSource);
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    public LDAPPropertiesMapper getLdapPropertiesMapper() {
        return this.ldapPropertiesMapper;
    }

    public Set<String> getValues(String name) {
        return this.attributes.getValues(name);
    }

    public String getValue(String name) {
        return this.attributes.getValue(name);
    }

    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    public long getAttributeAsLong(String name, long defaultValue) {
        return this.attributes.getAttributeAsLong(name, defaultValue);
    }

    public boolean getAttributeAsBoolean(String name, boolean defaultValue) {
        return this.attributes.getAttributeAsBoolean(name, defaultValue);
    }

    public Set<String> getKeys() {
        return this.attributes.getKeys();
    }

    public SearchDN getSearchDN() {
        return this.searchDN;
    }

    protected SearchControls getSubTreeSearchControl() {
        SearchControls searchControls = new SearchControls();
        searchControls.setSearchScope(2);
        searchControls.setReturningObjFlag(true);
        return searchControls;
    }

    protected Encoder getEncoder() {
        return new GenericEncoder();
    }

    protected Map<String, String> getBaseEnvironmentProperties() {
        return this.ldapPropertiesMapper.getEnvironment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected CollectingNameClassPairCallbackHandler pageSearchResults(Name baseDN, String filter, ContextMapper contextMapper, SearchControls searchControls, DirContextProcessor ldapRequestControls, int maxResults) throws OperationFailedException {
        ContextMapperCallbackHandler contextMapperCallbackHandler;
        DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition(0);
        TransactionStatus status = this.contextSourceTransactionManager.getTransaction((TransactionDefinition)transactionDefinition);
        try {
            int pagingSize = this.ldapPropertiesMapper.getPagedResultsSize();
            PagedResultsDirContextProcessor pagedResultsControl = new PagedResultsDirContextProcessor(pagingSize);
            if (logger.isDebugEnabled()) {
                logger.debug("Paged results are enabled with a paging size of: " + pagingSize);
            }
            ContextMapperCallbackHandler handler = new ContextMapperCallbackHandler(contextMapper);
            byte[] cookie = null;
            do {
                AggregateDirContextProcessor aggregateDirContextProcessor = new AggregateDirContextProcessor();
                aggregateDirContextProcessor.addDirContextProcessor((DirContextProcessor)pagedResultsControl);
                if (ldapRequestControls != null) {
                    aggregateDirContextProcessor.addDirContextProcessor(ldapRequestControls);
                }
                this.ldapTemplate.search(baseDN, filter, searchControls, (NameClassPairCallbackHandler)handler, (DirContextProcessor)aggregateDirContextProcessor);
                if (logger.isDebugEnabled()) {
                    int resultSize = pagedResultsControl.getPageSize();
                    logger.debug("Iterating a search result size of: " + resultSize);
                }
                if ((pagedResultsControl = new PagedResultsDirContextProcessor(pagingSize, pagedResultsControl.getCookie())).getCookie() == null) continue;
                cookie = pagedResultsControl.getCookie().getCookie();
            } while (cookie != null && cookie.length != 0 && (handler.getList().size() < maxResults || maxResults == -1));
            contextMapperCallbackHandler = handler;
        }
        catch (Throwable throwable) {
            try {
                this.contextSourceTransactionManager.commit(status);
                throw throwable;
            }
            catch (TransactionException e) {
                throw new OperationFailedException((Throwable)e);
            }
            catch (NamingException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        this.contextSourceTransactionManager.commit(status);
        return contextMapperCallbackHandler;
    }

    protected List searchEntities(Name baseDN, String filter, ContextMapper contextMapper, int startIndex, int maxResults) throws OperationFailedException {
        return this.searchEntitiesWithRequestControls(baseDN, filter, contextMapper, this.getSubTreeSearchControl(), null, startIndex, maxResults);
    }

    protected List searchEntitiesWithRequestControls(Name baseDN, String filter, ContextMapper contextMapper, SearchControls searchControls, DirContextProcessor ldapRequestControls, int startIndex, int maxResults) throws OperationFailedException {
        List<LDAPGroupWithAttributes> results;
        searchControls.setTimeLimit(this.ldapPropertiesMapper.getSearchTimeLimit());
        if (this.ldapPropertiesMapper.isPagedResultsControl()) {
            CollectingNameClassPairCallbackHandler handler = this.pageSearchResults(baseDN, filter, contextMapper, searchControls, ldapRequestControls, startIndex + maxResults);
            results = handler.getList();
        } else {
            try {
                results = ldapRequestControls != null ? this.ldapTemplate.search(baseDN, filter, searchControls, contextMapper, ldapRequestControls) : this.ldapTemplate.search(baseDN, filter, searchControls, contextMapper);
            }
            catch (NamingException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
        }
        if (contextMapper instanceof GroupContextMapper) {
            results = this.postprocessGroups(results);
        }
        return SearchResultsUtil.constrainResults(results, (int)startIndex, (int)maxResults);
    }

    private String spaceIfBlank(String value) {
        if (StringUtils.isBlank((String)value)) {
            return " ";
        }
        return value;
    }

    private ModificationItem createModificationItem(String directoryAttributeName, String oldValue, String newValue) {
        ModificationItem modificationItem = oldValue == null && newValue == null ? null : (oldValue == null ? new ModificationItem(1, new BasicAttribute(directoryAttributeName, this.spaceIfBlank(newValue))) : (!oldValue.equals(newValue) ? new ModificationItem(2, new BasicAttribute(directoryAttributeName, this.spaceIfBlank(newValue))) : null));
        return modificationItem;
    }

    public ContextMapper getUserContextMapper() {
        return new UserContextMapper(this.getDirectoryId(), this.ldapPropertiesMapper, this.getCustomUserAttributeMappers());
    }

    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        return new ArrayList<AttributeMapper>();
    }

    public ContextMapper getGroupContextMapper(GroupType groupType) {
        return new GroupContextMapper(this.getDirectoryId(), groupType, this.ldapPropertiesMapper, this.getCustomGroupAttributeMappers());
    }

    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        return new ArrayList<AttributeMapper>();
    }

    public LDAPUserWithAttributes findUserByName(String name) throws UserNotFoundException, OperationFailedException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.findUserWithAttributesByName(name);
    }

    public LDAPUserWithAttributes findUserWithAttributesByName(String name) throws UserNotFoundException, OperationFailedException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor(com.atlassian.crowd.model.user.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Restriction.on((Property)UserTermKeys.USERNAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPUserWithAttributes> users = this.searchUserObjects(query);
        if (users.isEmpty()) {
            throw new UserNotFoundException(name);
        }
        return users.get(0);
    }

    protected List<LDAPUserWithAttributes> searchUserObjects(EntityQuery query) throws OperationFailedException, IllegalArgumentException {
        List results;
        if (query == null) {
            throw new IllegalArgumentException("user search can only evaluate non-null EntityQueries for Entity.USER");
        }
        if (query.getEntityDescriptor().getEntityType() != Entity.USER) {
            throw new IllegalArgumentException("user search can only evaluate EntityQueries for Entity.USER");
        }
        Name baseDN = this.searchDN.getUser();
        try {
            LDAPQuery ldapQuery = this.ldapQueryTranslater.asLDAPFilter(query, this.ldapPropertiesMapper);
            String filter = ldapQuery.encode();
            logger.debug("Performing user search: baseDN = " + baseDN + " - filter = " + filter);
            results = this.searchEntities(baseDN, filter, this.getUserContextMapper(), query.getStartIndex(), query.getMaxResults());
        }
        catch (NullResultException e) {
            results = Collections.emptyList();
        }
        return results;
    }

    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        LDAPUserWithAttributes user = this.findUserByName(name);
        try {
            this.ldapTemplate.unbind(this.asLdapUserName(user.getDn(), name));
        }
        catch (NamingException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public void updateUserCredential(String name, PasswordCredential credential) throws InvalidCredentialException, UserNotFoundException, OperationFailedException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        Validate.notNull((Object)credential, (String)"credential argument cannot be null");
        ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, new BasicAttribute(this.ldapPropertiesMapper.getUserPasswordAttribute(), this.encodePassword(credential.getCredential())))};
        LdapName userDn = this.asLdapUserName(this.findUserByName(name).getDn(), name);
        try {
            this.ldapTemplate.modifyAttributes(userDn, mods);
        }
        catch (NamingException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public com.atlassian.crowd.model.user.User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        throw new OperationNotSupportedException("User renaming is not yet supported for LDAP directories");
    }

    public void storeUserAttributes(String username, Map<String, Set<String>> attributes) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("Custom user attributes are not yet supported for LDAP directories");
    }

    public void removeUserAttributes(String username, String attributeName) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("Custom user attributes are not yet supported for LDAP directories");
    }

    protected Attributes getNewUserAttributes(com.atlassian.crowd.model.user.User user, PasswordCredential credential) throws InvalidCredentialException, NamingException {
        LDAPUserAttributesMapper mapper = new LDAPUserAttributesMapper(this.getDirectoryId(), this.ldapPropertiesMapper);
        Attributes attributes = mapper.mapAttributesFromUser(user);
        if (credential != null && credential.getCredential() != null) {
            String unencodedPassword = credential.getCredential();
            attributes.put(this.ldapPropertiesMapper.getUserPasswordAttribute(), this.encodePassword(unencodedPassword));
        }
        this.getNewUserDirectorySpecificAttributes(user, attributes);
        return attributes;
    }

    protected void getNewUserDirectorySpecificAttributes(com.atlassian.crowd.model.user.User user, Attributes attributes) {
    }

    public LDAPUserWithAttributes addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, OperationFailedException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.notNull((Object)user.getName(), (String)"user.name cannot be null");
        try {
            Name dn = this.nameConverter.getName(this.ldapPropertiesMapper.getUserNameRdnAttribute(), user.getName(), this.searchDN.getUser());
            Attributes attrs = this.getNewUserAttributes((com.atlassian.crowd.model.user.User)user, credential);
            this.ldapTemplate.bind(dn, null, attrs);
            return this.findEntityByDN(this.getStandardisedDN(dn), LDAPUserWithAttributes.class);
        }
        catch (NamingException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (InvalidNameException e) {
            throw new InvalidUserException((User)user, e.getMessage(), (Throwable)e);
        }
        catch (GroupNotFoundException e) {
            throw new AssertionError((Object)"Should not throw a GroupNotFoundException");
        }
        catch (UserNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    protected void addDefaultSnToUserAttributes(Attributes attrs, String defaultSnValue) {
        this.addDefaultValueToUserAttributesForAttribute(this.ldapPropertiesMapper.getUserLastNameAttribute(), attrs, defaultSnValue);
    }

    protected void addDefaultValueToUserAttributesForAttribute(String attributeName, Attributes attrs, String defaultValue) {
        if (attrs == null) {
            return;
        }
        Attribute userAttribute = attrs.get(attributeName);
        if (userAttribute == null) {
            attrs.put(new BasicAttribute(attributeName, defaultValue));
        }
    }

    @Override
    public <T extends LDAPDirectoryEntity> T findEntityByDN(String dn, Class<T> entityClass) throws UserNotFoundException, GroupNotFoundException, OperationFailedException {
        dn = this.standardiseDN(dn);
        if (com.atlassian.crowd.model.user.User.class.isAssignableFrom(entityClass)) {
            return this.findEntityByDN(dn, this.getStandardisedDN(this.searchDN.getUser()), this.ldapPropertiesMapper.getUserFilter(), this.getUserContextMapper(), entityClass);
        }
        if (Group.class.isAssignableFrom(entityClass)) {
            T groupEntity;
            String groupBaseDN = this.getStandardisedDN(this.searchDN.getGroup());
            String roleBaseDN = this.getStandardisedDN(this.searchDN.getRole());
            if (dn.endsWith(groupBaseDN)) {
                groupEntity = this.findEntityByDN(dn, groupBaseDN, this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP), entityClass);
            } else if (dn.endsWith(roleBaseDN)) {
                if (this.ldapPropertiesMapper.isRolesDisabled()) {
                    throw new GroupNotFoundException("DN: " + dn);
                }
                groupEntity = this.findEntityByDN(dn, roleBaseDN, this.ldapPropertiesMapper.getRoleFilter(), this.getGroupContextMapper(GroupType.LEGACY_ROLE), entityClass);
            } else {
                groupEntity = this.findEntityByDN(dn, groupBaseDN, this.ldapPropertiesMapper.getGroupFilter(), this.getGroupContextMapper(GroupType.GROUP), entityClass);
            }
            return (T)this.postprocessGroups(Collections.singletonList((LDAPGroupWithAttributes)groupEntity)).get(0);
        }
        throw new IllegalArgumentException("Class " + entityClass.getCanonicalName() + " is not assignable from " + com.atlassian.crowd.model.user.User.class.getCanonicalName() + " or " + Group.class.getCanonicalName());
    }

    protected <T extends LDAPDirectoryEntity> RuntimeException typedEntityNotFoundException(String name, Class<T> entityClass) throws UserNotFoundException, GroupNotFoundException {
        if (com.atlassian.crowd.model.user.User.class.isAssignableFrom(entityClass)) {
            throw new UserNotFoundException(name);
        }
        if (Group.class.isAssignableFrom(entityClass)) {
            throw new GroupNotFoundException(name);
        }
        throw new IllegalArgumentException("Class " + entityClass.getCanonicalName() + " is not assignable from " + com.atlassian.crowd.model.user.User.class.getCanonicalName() + " or " + Group.class.getCanonicalName());
    }

    protected <T extends LDAPDirectoryEntity> T findEntityByDN(String dn, String baseDN, String filter, ContextMapper contextMapper, Class<T> entityClass) throws UserNotFoundException, GroupNotFoundException, OperationFailedException {
        if (StringUtils.isBlank((String)dn)) {
            throw this.typedEntityNotFoundException("Blank DN", entityClass);
        }
        if (dn.endsWith(baseDN)) {
            if (logger.isDebugEnabled()) {
                logger.debug("Executing search at DN: <" + dn + "> with filter: <" + filter + ">");
            }
            List entities = null;
            try {
                SearchControls searchControls = new SearchControls();
                searchControls.setSearchScope(0);
                searchControls.setTimeLimit(this.ldapPropertiesMapper.getSearchTimeLimit());
                searchControls.setReturningObjFlag(true);
                entities = this.ldapTemplate.search(this.asLdapName(dn, "DN: " + dn, entityClass), filter, searchControls, contextMapper);
            }
            catch (NameNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Search failed", (Throwable)e);
                }
            }
            catch (NamingException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
            if (entities != null && !entities.isEmpty()) {
                return (T)((LDAPDirectoryEntity)entities.get(0));
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Entity DN <" + dn + "> does not exist or does not match filter <" + filter + ">");
            }
            throw this.typedEntityNotFoundException("DN: " + dn, entityClass);
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Entity DN <" + dn + "> is outside the entity base DN subtree scope <" + baseDN + ">");
        }
        throw this.typedEntityNotFoundException("DN: " + dn, entityClass);
    }

    public com.atlassian.crowd.model.user.User updateUser(UserTemplate user) throws UserNotFoundException, OperationFailedException {
        Validate.notNull((Object)user, (String)"user cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)user.getName()), (String)"user cannot have blank user name");
        com.atlassian.crowd.model.user.User populatedUser = UserUtils.populateNames((com.atlassian.crowd.model.user.User)user);
        LDAPUserWithAttributes currentUser = this.findUserByName(user.getName());
        String ldapUserObjectType = this.ldapPropertiesMapper.getUserObjectClass();
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        if ("inetOrgPerson".equalsIgnoreCase(ldapUserObjectType) || "user".equalsIgnoreCase(ldapUserObjectType)) {
            ModificationItem displayNameMod;
            ModificationItem givenNameMod;
            ModificationItem mailMod;
            ModificationItem snMod = this.createModificationItem(this.ldapPropertiesMapper.getUserLastNameAttribute(), currentUser.getLastName(), this.spaceIfBlank(populatedUser.getLastName()));
            if (snMod != null) {
                modificationItems.add(snMod);
            }
            if ((mailMod = this.createModificationItem(this.ldapPropertiesMapper.getUserEmailAttribute(), currentUser.getEmailAddress(), this.spaceIfBlank(populatedUser.getEmailAddress()))) != null) {
                modificationItems.add(mailMod);
            }
            if ((givenNameMod = this.createModificationItem(this.ldapPropertiesMapper.getUserFirstNameAttribute(), currentUser.getFirstName(), this.spaceIfBlank(populatedUser.getFirstName()))) != null) {
                modificationItems.add(givenNameMod);
            }
            if ((displayNameMod = this.createModificationItem(this.ldapPropertiesMapper.getUserDisplayNameAttribute(), currentUser.getDisplayName(), this.spaceIfBlank(populatedUser.getDisplayName()))) != null) {
                modificationItems.add(displayNameMod);
            }
        }
        if (!modificationItems.isEmpty()) {
            try {
                this.ldapTemplate.modifyAttributes(this.asLdapUserName(currentUser.getDn(), user.getName()), modificationItems.toArray(new ModificationItem[modificationItems.size()]));
            }
            catch (NamingException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
        }
        try {
            return (com.atlassian.crowd.model.user.User)this.findEntityByDN(currentUser.getDn(), LDAPUserWithAttributes.class);
        }
        catch (GroupNotFoundException e) {
            throw new AssertionError((Object)"Should not throw a GroupNotFoundException");
        }
    }

    public <T> List<T> searchUsers(EntityQuery<T> query) throws OperationFailedException {
        List<LDAPUserWithAttributes> users = this.searchUserObjects(query);
        if (query.getReturnType() == String.class) {
            return SearchResultsUtil.convertEntitiesToNames(users);
        }
        return users;
    }

    public com.atlassian.crowd.model.user.User authenticate(String name, PasswordCredential credential) throws InvalidAuthenticationException, UserNotFoundException, OperationFailedException {
        LdapContextSource ctxSource = new LdapContextSource();
        ctxSource.setUrl(this.ldapPropertiesMapper.getConnectionURL());
        LDAPUserWithAttributes user = this.findUserByName(name);
        ctxSource.setUserDn(user.getDn());
        if (credential == null || StringUtils.isBlank((String)credential.getCredential())) {
            throw new InvalidAuthenticationException("You cannot authenticate with a blank password");
        }
        ctxSource.setPassword(credential.getCredential());
        ctxSource.setBaseEnvironmentProperties(this.getBaseEnvironmentProperties());
        ctxSource.setPooled(false);
        try {
            ctxSource.afterPropertiesSet();
            ctxSource.getReadWriteContext();
        }
        catch (NamingException e) {
            throw new InvalidAuthenticationException(name, (Throwable)e);
        }
        catch (Exception e) {
            throw new InvalidAuthenticationException(name, (Throwable)e);
        }
        return user;
    }

    public LDAPGroupWithAttributes findGroupByName(String name) throws GroupNotFoundException, OperationFailedException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        return this.findGroupWithAttributesByName(name);
    }

    public LDAPGroupWithAttributes findGroupWithAttributesByName(String name) throws GroupNotFoundException, OperationFailedException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group(null)).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (groups.isEmpty()) {
            throw new GroupNotFoundException(name);
        }
        return groups.get(0);
    }

    protected LDAPGroupWithAttributes findGroupByNameAndType(String name, GroupType groupType) throws GroupNotFoundException, OperationFailedException {
        Validate.notNull((Object)name, (String)"name argument cannot be null");
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).exactlyMatching((Object)name)).returningAtMost(1);
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (groups.isEmpty()) {
            throw new GroupNotFoundException(name);
        }
        return groups.get(0);
    }

    protected List<LDAPGroupWithAttributes> searchGroupObjectsOfSpecifiedGroupType(EntityQuery query) throws OperationFailedException {
        List results;
        Name baseDN;
        GroupType groupType = query.getEntityDescriptor().getGroupType();
        if (GroupType.GROUP.equals((Object)groupType)) {
            baseDN = this.searchDN.getGroup();
        } else if (GroupType.LEGACY_ROLE.equals((Object)groupType)) {
            baseDN = this.searchDN.getRole();
        } else {
            throw new IllegalArgumentException("Cannot search for groups of type: " + groupType);
        }
        try {
            LDAPQuery ldapQuery = this.ldapQueryTranslater.asLDAPFilter(query, this.ldapPropertiesMapper);
            String filter = ldapQuery.encode();
            logger.debug("Performing group search: baseDN = " + baseDN + " - filter = " + filter);
            results = this.searchEntities(baseDN, filter, this.getGroupContextMapper(groupType), query.getStartIndex(), query.getMaxResults());
        }
        catch (NullResultException e) {
            results = Collections.emptyList();
        }
        return results;
    }

    protected List<LDAPGroupWithAttributes> searchGroupObjects(EntityQuery query) throws OperationFailedException {
        Validate.notNull((Object)query, (String)"query argument cannot be null");
        if (query.getEntityDescriptor().getEntityType() != Entity.GROUP) {
            throw new IllegalArgumentException("group search can only evaluate EntityQueries for Entity.GROUP");
        }
        GroupType groupType = query.getEntityDescriptor().getGroupType();
        if (groupType == null) {
            ArrayList<LDAPGroupWithAttributes> results = new ArrayList<LDAPGroupWithAttributes>();
            int groupStartIndex = query.getStartIndex();
            int groupMaxResults = query.getMaxResults();
            if (!this.ldapPropertiesMapper.isRolesDisabled()) {
                groupStartIndex = 0;
                groupMaxResults = -1;
            }
            GroupQuery groupQuery = new GroupQuery(Group.class, GroupType.GROUP, query.getSearchRestriction(), groupStartIndex, groupMaxResults);
            results.addAll(this.searchGroupObjectsOfSpecifiedGroupType((EntityQuery)groupQuery));
            if (!this.ldapPropertiesMapper.isRolesDisabled()) {
                GroupQuery roleQuery = new GroupQuery(Group.class, GroupType.LEGACY_ROLE, query.getSearchRestriction(), groupStartIndex, groupMaxResults);
                results.addAll(this.searchGroupObjectsOfSpecifiedGroupType((EntityQuery)roleQuery));
            }
            return SearchResultsUtil.constrainResults(results, (int)query.getStartIndex(), (int)query.getMaxResults());
        }
        return this.searchGroupObjectsOfSpecifiedGroupType(query);
    }

    public <T> List<T> searchGroups(EntityQuery<T> query) throws OperationFailedException {
        Validate.notNull(query, (String)"query argument cannot be null");
        List<LDAPGroupWithAttributes> groups = this.searchGroupObjects(query);
        if (query.getReturnType() == String.class) {
            return SearchResultsUtil.convertEntitiesToNames(groups);
        }
        return groups;
    }

    protected List<LDAPGroupWithAttributes> postprocessGroups(List<LDAPGroupWithAttributes> groups) {
        return groups;
    }

    protected Attributes getNewGroupAttributes(Group group) throws NamingException {
        LDAPGroupAttributesMapper mapper = new LDAPGroupAttributesMapper(this.getDirectoryId(), group.getType(), this.ldapPropertiesMapper);
        Attributes attributes = mapper.mapAttributesFromGroup(group);
        this.getNewGroupDirectorySpecificAttributes(group, attributes);
        String defaultContainerMemberDN = this.getInitialGroupMemberDN();
        if (defaultContainerMemberDN != null) {
            attributes.put(new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), defaultContainerMemberDN));
        }
        return attributes;
    }

    protected void getNewGroupDirectorySpecificAttributes(Group group, Attributes attributes) {
    }

    protected String getInitialGroupMemberDN() {
        return "";
    }

    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        String nameAttribute;
        Name baseDN;
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)group.getName()), (String)"group cannot have blank group name");
        if (this.groupExists((Group)group)) {
            throw new InvalidGroupException((Group)group, "Group already exists");
        }
        if (group.getType() == GroupType.GROUP) {
            baseDN = this.searchDN.getGroup();
            nameAttribute = this.ldapPropertiesMapper.getGroupNameAttribute();
        } else if (group.getType() == GroupType.LEGACY_ROLE) {
            baseDN = this.searchDN.getRole();
            nameAttribute = this.ldapPropertiesMapper.getRoleNameAttribute();
        } else {
            throw new InvalidGroupException((Group)group, "group.type must be GroupType.GROUP or GroupType.LEGACY_ROLE");
        }
        try {
            Name dn = this.nameConverter.getName(nameAttribute, group.getName(), baseDN);
            Attributes groupAttributes = this.getNewGroupAttributes((Group)group);
            this.ldapTemplate.bind(dn, null, groupAttributes);
            return (Group)this.findEntityByDN(this.getStandardisedDN(dn), LDAPGroupWithAttributes.class);
        }
        catch (UserNotFoundException e) {
            throw new AssertionError((Object)"Should not throw UserNotFoundException");
        }
        catch (GroupNotFoundException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (NamingException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
        catch (InvalidNameException e) {
            throw new InvalidGroupException((Group)group, e.getMessage(), (Throwable)e);
        }
    }

    public Group updateGroup(GroupTemplate group) throws GroupNotFoundException, OperationFailedException {
        Validate.notNull((Object)group, (String)"group cannot be null");
        Validate.isTrue((boolean)StringUtils.isNotBlank((String)group.getName()), (String)"group cannot have blank group name");
        LDAPGroupWithAttributes currentGroup = this.findGroupByName(group.getName());
        if (currentGroup.getType() != group.getType()) {
            throw new OperationNotSupportedException("Cannot modify the GroupType for an LDAP group");
        }
        ArrayList<ModificationItem> modificationItems = new ArrayList<ModificationItem>();
        String descriptionAttribute = group.getType() == GroupType.GROUP ? this.ldapPropertiesMapper.getGroupDescriptionAttribute() : this.ldapPropertiesMapper.getRoleDescriptionAttribute();
        ModificationItem descriptionMod = this.createModificationItem(descriptionAttribute, currentGroup.getDescription(), group.getDescription());
        if (descriptionMod != null) {
            modificationItems.add(descriptionMod);
        }
        if (!modificationItems.isEmpty()) {
            try {
                this.ldapTemplate.modifyAttributes(this.asLdapGroupName(currentGroup.getDn(), group.getName()), modificationItems.toArray(new ModificationItem[modificationItems.size()]));
            }
            catch (NamingException ex) {
                throw new OperationFailedException((Throwable)ex);
            }
        }
        try {
            return (Group)this.findEntityByDN(currentGroup.getDn(), LDAPGroupWithAttributes.class);
        }
        catch (UserNotFoundException e) {
            throw new AssertionError((Object)"Should not throw UserNotFoundException.");
        }
    }

    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException {
        Validate.notEmpty((String)name, (String)"name argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(name);
        try {
            this.ldapTemplate.unbind(this.asLdapGroupName(group.getDn(), name));
        }
        catch (NamingException ex) {
            throw new OperationFailedException((Throwable)ex);
        }
    }

    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException("Group renaming is not yet supported for LDAP directories");
    }

    public void storeGroupAttributes(String groupName, Map<String, Set<String>> attributes) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("Custom group attributes are not yet supported for LDAP directories");
    }

    public void removeGroupAttributes(String groupName, String attributeName) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("Custom group attributes are not yet supported for LDAP directories");
    }

    public <T> List<T> searchGroupRelationships(MembershipQuery<T> query) throws OperationFailedException {
        List<T> results;
        Validate.notNull(query, (String)"query argument cannot be null");
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP && query.getEntityToMatch().getEntityType() != query.getEntityToReturn().getEntityType()) {
            throw new IllegalArgumentException("Cannot search for group relationships of mismatching GroupTypes: attempted to match <" + query.getEntityToMatch().getEntityType() + "> and return <" + query.getEntityToReturn().getEntityType() + ">");
        }
        if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.USER) {
            GroupType groupType = query.getEntityToMatch().getGroupType();
            if (groupType == null) {
                MembershipQuery groupQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)query.getEntityToReturn(), (Class)query.getReturnType(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), (String)query.getEntityNameToMatch());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else if (query.getEntityToMatch().getEntityType() == Entity.USER && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            GroupType groupType = query.getEntityToReturn().getGroupType();
            if (groupType == null) {
                MembershipQuery groupQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), (Class)query.getReturnType(), (EntityDescriptor)query.getEntityToMatch(), (String)query.getEntityNameToMatch());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else if (query.getEntityToMatch().getEntityType() == Entity.GROUP && query.getEntityToReturn().getEntityType() == Entity.GROUP) {
            GroupType groupTypeToReturn;
            GroupType groupTypeToMatch = query.getEntityToMatch().getGroupType();
            if (groupTypeToMatch != (groupTypeToReturn = query.getEntityToReturn().getGroupType())) {
                throw new IllegalArgumentException("Cannot search for group relationships of mismatching GroupTypes: attempted to match <" + groupTypeToMatch + "> and return <" + groupTypeToReturn + ">");
            }
            if (groupTypeToReturn == null) {
                MembershipQuery groupQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP), (Class)query.getReturnType(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP), (String)query.getEntityNameToMatch());
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(groupQuery);
                if (!this.ldapPropertiesMapper.isRolesDisabled() && results.isEmpty()) {
                    MembershipQuery roleQuery = QueryBuilder.createMembershipQuery((int)query.getMaxResults(), (int)query.getStartIndex(), (boolean)query.isFindChildren(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), (Class)query.getReturnType(), (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE), (String)query.getEntityNameToMatch());
                    results = this.searchGroupRelationshipsWithGroupTypeSpecified(roleQuery);
                }
            } else {
                results = this.searchGroupRelationshipsWithGroupTypeSpecified(query);
            }
        } else {
            throw new IllegalArgumentException("Cannot search for relationships between a USER and another USER");
        }
        return results;
    }

    protected abstract <T> List<T> searchGroupRelationshipsWithGroupTypeSpecified(MembershipQuery<T> var1) throws OperationFailedException;

    protected abstract Object encodePassword(String var1) throws InvalidCredentialException;

    public boolean supportsNestedGroups() {
        return !this.ldapPropertiesMapper.isNestedGroupsDisabled();
    }

    public boolean isRolesDisabled() {
        return this.ldapPropertiesMapper.isRolesDisabled();
    }

    public void testConnection() throws OperationFailedException {
        try {
            LdapContext ldapContext = (LdapContext)this.contextSource.getReadOnlyContext();
            ldapContext.getConnectControls();
        }
        catch (Exception e) {
            throw new OperationFailedException(e.getMessage());
        }
    }

    protected String getStandardisedDN(Name dn) throws OperationFailedException {
        try {
            return DNStandardiser.standardise(new DistinguishedName(dn), !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
        }
        catch (NamingException e) {
            throw new OperationFailedException("Failed to parse distinguished name", (Throwable)e);
        }
    }

    final String standardiseDN(String dn) {
        return DNStandardiser.standardise(dn, !this.ldapPropertiesMapper.isRelaxedDnStandardisation());
    }

    protected <T extends LDAPDirectoryEntity> LdapName asLdapName(String dn, String entityName, Class<T> entityClass) throws UserNotFoundException, GroupNotFoundException {
        try {
            return new LdapName(dn);
        }
        catch (InvalidNameException e) {
            throw this.typedEntityNotFoundException(entityName, entityClass);
        }
    }

    protected LdapName asLdapGroupName(String dn, String groupName) throws GroupNotFoundException {
        try {
            return this.asLdapName(dn, groupName, LDAPGroupWithAttributes.class);
        }
        catch (UserNotFoundException e) {
            throw new AssertionError((Object)"Should not throw UserNotFoundException.");
        }
    }

    protected LdapName asLdapUserName(String dn, String userName) throws UserNotFoundException {
        try {
            return this.asLdapName(dn, userName, LDAPUserWithAttributes.class);
        }
        catch (GroupNotFoundException e) {
            throw new AssertionError((Object)"Should not throw GroupNotFoundException.");
        }
    }

    public boolean supportsInactiveAccounts() {
        return false;
    }

    public RemoteDirectory getAuthoritativeDirectory() {
        return this;
    }

    private boolean groupExists(Group group) throws OperationFailedException {
        try {
            this.findGroupByName(group.getName());
            return true;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    public Iterable<Membership> getMemberships() throws OperationFailedException {
        return new DirectoryMembershipsIterable((RemoteDirectory)this);
    }
}

