/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.name;

import com.atlassian.crowd.directory.ldap.name.Converter;
import com.atlassian.crowd.directory.ldap.name.Encoder;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.Name;

public class GenericConverter
implements Converter {
    private final Encoder encoder;

    public GenericConverter(Encoder encoder) {
        this.encoder = encoder;
    }

    @Override
    public Name getName(String dn) throws InvalidNameException {
        String escapedDn = this.encoder.dnEncode(dn);
        return new CompositeName(escapedDn);
    }

    @Override
    public Name getName(String attributeName, String objectName, Name baseDN) throws InvalidNameException {
        String dn = attributeName + "=" + this.encoder.nameEncode(objectName);
        if (baseDN != null && !baseDN.isEmpty()) {
            dn = dn + ", " + baseDN;
        }
        return new CompositeName(dn);
    }
}

