/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteCrowdDirectory;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.RemoteDirectoryCacheRefresher;
import com.atlassian.crowd.event.EventTokenExpiredException;
import com.atlassian.crowd.event.Events;
import com.atlassian.crowd.event.IncrementalSynchronisationNotAvailableException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UnsupportedCrowdApiException;
import com.atlassian.crowd.model.event.GroupEvent;
import com.atlassian.crowd.model.event.GroupMembershipEvent;
import com.atlassian.crowd.model.event.Operation;
import com.atlassian.crowd.model.event.OperationEvent;
import com.atlassian.crowd.model.event.UserEvent;
import com.atlassian.crowd.model.event.UserMembershipEvent;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventTokenChangedCacheRefresher
extends AbstractCacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(EventTokenChangedCacheRefresher.class);
    private final RemoteDirectoryCacheRefresher fullSyncCacheRefresher;
    private final RemoteCrowdDirectory crowdDirectory;
    private String currentEventToken;

    public EventTokenChangedCacheRefresher(RemoteCrowdDirectory crowdDirectory) {
        super((RemoteDirectory)crowdDirectory);
        this.crowdDirectory = crowdDirectory;
        this.fullSyncCacheRefresher = new RemoteDirectoryCacheRefresher(this.remoteDirectory);
    }

    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        try {
            this.currentEventToken = this.crowdDirectory.getCurrentEventToken();
        }
        catch (UnsupportedCrowdApiException e) {
            log.debug("Remote server does not support event based sync.");
        }
        catch (OperationFailedException e) {
            log.warn("Could not update event token.", (Throwable)e);
        }
        catch (IncrementalSynchronisationNotAvailableException e) {
            log.warn("Incremental synchronisation is not available. Falling back to full synchronisation", (Throwable)e);
        }
        this.fullSyncCacheRefresher.synchroniseAll(directoryCache);
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        Events events;
        if (this.currentEventToken == null || !Boolean.parseBoolean(this.crowdDirectory.getValue("crowd.sync.incremental.enabled"))) {
            return false;
        }
        try {
            events = this.crowdDirectory.getNewEvents(this.currentEventToken);
        }
        catch (EventTokenExpiredException e) {
            this.currentEventToken = null;
            return false;
        }
        for (OperationEvent event : events.getEvents()) {
            UserMembershipEvent membershipEvent;
            if (event instanceof UserEvent) {
                UserEvent userEvent = (UserEvent)event;
                if (event.getOperation() == Operation.CREATED || event.getOperation() == Operation.UPDATED) {
                    directoryCache.addOrUpdateCachedUser(userEvent.getUser());
                    continue;
                }
                if (event.getOperation() != Operation.DELETED) continue;
                directoryCache.deleteCachedUser(userEvent.getUser().getName());
                continue;
            }
            if (event instanceof GroupEvent) {
                GroupEvent groupEvent = (GroupEvent)event;
                if (event.getOperation() == Operation.CREATED || event.getOperation() == Operation.UPDATED) {
                    directoryCache.addOrUpdateCachedGroup(groupEvent.getGroup());
                    continue;
                }
                if (event.getOperation() != Operation.DELETED) continue;
                directoryCache.deleteCachedGroup(groupEvent.getGroup().getName());
                continue;
            }
            if (event instanceof UserMembershipEvent) {
                membershipEvent = (UserMembershipEvent)event;
                if (event.getOperation() == Operation.CREATED) {
                    for (String parentGroupName : membershipEvent.getParentGroupNames()) {
                        directoryCache.addUserToGroup(membershipEvent.getChildUsername(), parentGroupName);
                    }
                    continue;
                }
                if (event.getOperation() == Operation.DELETED) {
                    for (String parentGroupName : membershipEvent.getParentGroupNames()) {
                        directoryCache.removeUserFromGroup(membershipEvent.getChildUsername(), parentGroupName);
                    }
                    continue;
                }
                if (event.getOperation() != Operation.UPDATED) continue;
                directoryCache.syncGroupMembershipsForUser(membershipEvent.getChildUsername(), membershipEvent.getParentGroupNames());
                continue;
            }
            if (event instanceof GroupMembershipEvent) {
                membershipEvent = (GroupMembershipEvent)event;
                if (event.getOperation() == Operation.CREATED) {
                    for (String parentGroupName : membershipEvent.getParentGroupNames()) {
                        directoryCache.addGroupToGroup(membershipEvent.getGroupName(), parentGroupName);
                    }
                    continue;
                }
                if (event.getOperation() == Operation.DELETED) {
                    for (String parentGroupName : membershipEvent.getParentGroupNames()) {
                        directoryCache.removeGroupFromGroup(membershipEvent.getGroupName(), parentGroupName);
                    }
                    continue;
                }
                if (event.getOperation() != Operation.UPDATED) continue;
                directoryCache.syncGroupMembershipsAndMembersForGroup(membershipEvent.getGroupName(), membershipEvent.getParentGroupNames(), membershipEvent.getChildGroupNames());
                continue;
            }
            throw new RuntimeException("Unsupported event " + event);
        }
        this.currentEventToken = events.getNewEventToken();
        return true;
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(GroupType legacyRole, DirectoryCache directoryCache) throws OperationFailedException {
        throw new UnsupportedOperationException();
    }
}

