/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.DirectoryMembershipsIterable;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.embedded.impl.IdentifierMap;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.Membership;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheRefresher.class);
    static final int MEMBERSHIP_LOG_FREQUENCY = 5;
    protected final RemoteDirectory remoteDirectory;

    public AbstractCacheRefresher(RemoteDirectory remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    protected static <T extends Group> List<T> filterOutDuplicateGroups(List<T> remoteGroups) {
        LinkedHashMap groupMap = Maps.newLinkedHashMap();
        HashSet badGroups = Sets.newHashSet();
        for (Group ldapGroup : remoteGroups) {
            Group origGroup;
            String groupId = IdentifierUtils.toLowerCase((String)ldapGroup.getName());
            if (badGroups.contains(groupId) || (origGroup = groupMap.put(groupId, ldapGroup)) == null) continue;
            groupMap.remove(groupId);
            badGroups.add(groupId);
            if (!origGroup.getName().equals(ldapGroup.getName())) {
                log.warn("group [{}] duplicated in remote directory by group [{}]. Ignoring group.", (Object)origGroup.getName(), (Object)ldapGroup.getName());
                continue;
            }
            log.warn("group [{}] duplicated in remote directory. Ignoring group.", (Object)origGroup.getName());
        }
        return badGroups.isEmpty() ? remoteGroups : ImmutableList.copyOf(groupMap.values());
    }

    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        this.synchroniseAllUsers(directoryCache);
        List<? extends Group> allGroups = this.synchroniseAllGroups(GroupType.GROUP, directoryCache);
        this.synchroniseMemberships(allGroups, directoryCache);
        if (!this.remoteDirectory.isRolesDisabled()) {
            List<? extends Group> allRoles = this.synchroniseAllGroups(GroupType.LEGACY_ROLE, directoryCache);
            this.synchroniseMemberships(GroupType.LEGACY_ROLE, allRoles, directoryCache);
        }
    }

    protected abstract void synchroniseAllUsers(DirectoryCache var1) throws OperationFailedException;

    protected abstract List<? extends Group> synchroniseAllGroups(GroupType var1, DirectoryCache var2) throws OperationFailedException;

    protected void synchroniseMemberships(GroupType groupType, List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        if (groupType == GroupType.GROUP) {
            this.synchroniseMemberships(remoteGroups, directoryCache);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Updating memberships for " + remoteGroups.size() + " " + groupType.name() + "s from " + this.directoryDescription());
        }
        int total = remoteGroups.size();
        int logEvery = total / 5;
        for (int i = 0; i < total; ++i) {
            this.synchroniseMembershipsForGroup(groupType, remoteGroups.get(i), directoryCache);
            if (logEvery != 0 && i % logEvery != 0) continue;
            log.info("Migrated memberships for [" + i + "] of [" + total + "] groups");
        }
    }

    private List<String> findAllUserMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info("found [ " + names.size() + " ] remote user-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]");
        return names;
    }

    private List<String> findAllGroupMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)type)).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info("found [ " + names.size() + " ] remote group-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]");
        return names;
    }

    protected void synchroniseMembershipsForGroup(GroupType groupType, Group ldapGroup, DirectoryCache directoryCache) throws OperationFailedException {
        List<String> ldapUsers = this.findAllUserMembersOfGroup(ldapGroup.getName(), groupType);
        directoryCache.syncUserMembersForGroup(ldapGroup, ldapUsers);
        if (this.remoteDirectory.supportsNestedGroups()) {
            List<String> ldapSubGroups = this.findAllGroupMembersOfGroup(ldapGroup.getName(), groupType);
            directoryCache.syncGroupMembersForGroup(ldapGroup, ldapSubGroups);
        }
    }

    Iterable<Membership> getMemberships(Iterable<String> names) throws OperationFailedException {
        return this.remoteDirectory.getMemberships();
    }

    protected void synchroniseMemberships(List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        if (log.isDebugEnabled()) {
            log.debug("Updating memberships for " + remoteGroups.size() + " groups from " + this.directoryDescription());
        }
        int total = remoteGroups.size();
        int logEvery = total / 5;
        IdentifierMap groupsByName = new IdentifierMap();
        for (Group group : remoteGroups) {
            String name = (String)DirectoryMembershipsIterable.GROUPS_TO_NAMES.apply((Object)group);
            if (null == groupsByName.put(name, group)) continue;
            throw new OperationFailedException("Unable to synchronise directory: duplicate groups with name '" + name + "'");
        }
        int i = 0;
        Iterable<Membership> iterable = this.getMemberships(groupsByName.keySet());
        Iterator<Membership> iter = iterable.iterator();
        while (iter.hasNext()) {
            long start = System.currentTimeMillis();
            Membership membership = iter.next();
            long finish = System.currentTimeMillis();
            long duration = finish - start;
            log.info("found [ " + membership.getUserNames().size() + " ] remote user-group memberships, " + "[ " + membership.getChildGroupNames().size() + " ] remote group-group memberships in [ " + duration + "ms ]");
            Group g = (Group)groupsByName.get(membership.getGroupName());
            if (g == null) {
                log.debug("Unexpected group in response: " + membership.getGroupName());
                continue;
            }
            directoryCache.syncUserMembersForGroup(g, membership.getUserNames());
            if (this.remoteDirectory.supportsNestedGroups()) {
                directoryCache.syncGroupMembersForGroup(g, membership.getChildGroupNames());
            }
            if (logEvery != 0 && ++i % logEvery != 0) continue;
            log.info("Migrated memberships for [" + i + "] of [" + total + "] groups");
        }
    }

    protected String directoryDescription() {
        return this.remoteDirectory.getDescriptiveName() + " Directory " + this.remoteDirectory.getDirectoryId();
    }
}

