/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.SpringLDAPConnector;
import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.group.RFC4519MemberDnMapper;
import com.atlassian.crowd.directory.ldap.mapper.attribute.user.MemberOfOverlayMapper;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidMembershipException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.LDAPDirectoryEntity;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.search.Entity;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.crowd.search.util.SearchResultsUtil;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.naming.Name;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.ModificationItem;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;
import org.springframework.ldap.AttributeInUseException;
import org.springframework.ldap.NameAlreadyBoundException;
import org.springframework.ldap.NamingException;
import org.springframework.ldap.OperationNotSupportedException;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.filter.AndFilter;
import org.springframework.ldap.filter.EqualsFilter;
import org.springframework.ldap.filter.Filter;
import org.springframework.ldap.filter.HardcodedFilter;

public abstract class RFC4519Directory
extends SpringLDAPConnector {
    private static final Logger logger = Logger.getLogger(RFC4519Directory.class);

    public RFC4519Directory(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
    }

    @Override
    protected List<AttributeMapper> getCustomGroupAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomGroupAttributeMappers();
        mappers.addAll(this.getMemberDnMappers());
        return mappers;
    }

    protected List<AttributeMapper> getMemberDnMappers() {
        return Collections.singletonList(new RFC4519MemberDnMapper(this.ldapPropertiesMapper.getGroupMemberAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation()));
    }

    @Override
    protected List<AttributeMapper> getCustomUserAttributeMappers() {
        List<AttributeMapper> mappers = super.getCustomUserAttributeMappers();
        if (this.ldapPropertiesMapper.isUsingUserMembershipAttributeForGroupMembership()) {
            mappers.add(new MemberOfOverlayMapper(this.ldapPropertiesMapper.getUserGroupMembershipsAttribute(), this.ldapPropertiesMapper.isRelaxedDnStandardisation()));
        }
        return mappers;
    }

    private Set<String> getMemberDNs(LDAPGroupWithAttributes group) {
        return group.getValues("memberDNs");
    }

    private Set<String> getMemberOfs(LDAPUserWithAttributes user) {
        return user.getValues("memberOf");
    }

    private boolean isDnDirectGroupMember(String memberDN, LDAPGroupWithAttributes parentGroup) {
        boolean isMember = false;
        Set<String> memberDNs = this.getMemberDNs(parentGroup);
        if (memberDNs != null) {
            HashSet<String> normal = new HashSet<String>();
            for (String dn : memberDNs) {
                normal.add(this.standardiseDN(dn));
            }
            isMember = normal.contains(this.standardiseDN(memberDN));
        }
        return isMember;
    }

    public boolean isUserDirectGroupMember(String username, String groupName) throws OperationFailedException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        try {
            LDAPGroupWithAttributes group = this.findGroupByName(groupName);
            LDAPUserWithAttributes user = this.findUserByName(username);
            return this.isDnDirectGroupMember(user.getDn(), group);
        }
        catch (UserNotFoundException e) {
            return false;
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    public boolean isGroupDirectGroupMember(String childGroup, String parentGroup) throws OperationFailedException {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        try {
            LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
            LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
            return this.isDnDirectGroupMember(child.getDn(), parent);
        }
        catch (GroupNotFoundException e) {
            return false;
        }
    }

    private void addDnToGroup(String dn, LDAPGroupWithAttributes group) throws OperationFailedException {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(1, new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn))};
            this.ldapTemplate.modifyAttributes(this.asLdapGroupName(group.getDn(), group.getName()), mods);
        }
        catch (AttributeInUseException e) {
        }
        catch (NameAlreadyBoundException e) {
        }
        catch (GroupNotFoundException e) {
            logger.error((Object)("Could not modify members of group with DN: " + dn), (Throwable)e);
        }
        catch (NamingException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void addUserToGroup(String username, String groupName) throws GroupNotFoundException, OperationFailedException, UserNotFoundException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(groupName);
        LDAPUserWithAttributes user = this.findUserByName(username);
        this.addDnToGroup(user.getDn(), group);
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, InvalidMembershipException, OperationFailedException {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
        LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
        if (parent.getType() != child.getType()) {
            throw new InvalidMembershipException("Cannot add group of type " + child.getType().name() + " to group of type " + parent.getType().name());
        }
        this.addDnToGroup(child.getDn(), parent);
    }

    private void removeDnFromGroup(String dn, LDAPGroupWithAttributes group) throws OperationFailedException {
        try {
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(3, new BasicAttribute(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn))};
            this.ldapTemplate.modifyAttributes(this.asLdapGroupName(group.getDn(), group.getName()), mods);
        }
        catch (OperationNotSupportedException e) {
        }
        catch (GroupNotFoundException e) {
            logger.error((Object)("Could not modify memers of group with DN: " + dn), (Throwable)e);
        }
        catch (NamingException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public void removeUserFromGroup(String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, OperationFailedException {
        Validate.notEmpty((String)username, (String)"username argument cannot be null or empty");
        Validate.notEmpty((String)groupName, (String)"groupName argument cannot be null or empty");
        LDAPGroupWithAttributes group = this.findGroupByName(groupName);
        LDAPUserWithAttributes user = this.findUserByName(username);
        if (!this.isDnDirectGroupMember(user.getDn(), group)) {
            throw new MembershipNotFoundException(username, groupName);
        }
        this.removeDnFromGroup(user.getDn(), group);
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, MembershipNotFoundException, InvalidMembershipException, OperationFailedException {
        Validate.notEmpty((String)childGroup, (String)"childGroup argument cannot be null or empty");
        Validate.notEmpty((String)parentGroup, (String)"parentGroup argument cannot be null or empty");
        LDAPGroupWithAttributes parent = this.findGroupByName(parentGroup);
        LDAPGroupWithAttributes child = this.findGroupByName(childGroup);
        if (!this.isDnDirectGroupMember(child.getDn(), parent)) {
            throw new MembershipNotFoundException(childGroup, parentGroup);
        }
        if (parent.getType() != child.getType()) {
            throw new InvalidMembershipException("Cannot remove group of type " + child.getType().name() + " from group of type " + parent.getType().name());
        }
        this.removeDnFromGroup(child.getDn(), parent);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected <T> List<T> searchGroupRelationshipsWithGroupTypeSpecified(MembershipQuery<T> query) throws OperationFailedException {
        void var2_10;
        if (query.isFindChildren()) {
            if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
            if (query.getEntityToReturn().getEntityType() == Entity.USER) {
                if (this.ldapPropertiesMapper.isUsingUserMembershipAttribute()) {
                    List<LDAPUserWithAttributes> list = this.findUserMembersOfGroupViaMemberOf(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                } else {
                    List<LDAPUserWithAttributes> list = this.findUserMembersOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            } else {
                if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP or USER members of a GROUP");
                if (this.ldapPropertiesMapper.isNestedGroupsDisabled()) {
                    List list = Collections.emptyList();
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembersOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToMatch().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            }
        } else {
            if (query.getEntityToReturn().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
            if (query.getEntityToMatch().getEntityType() == Entity.USER) {
                if (this.ldapPropertiesMapper.isUsingUserMembershipAttributeForGroupMembership()) {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfUserViaMemberOf(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfUserViaMemberDN(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            } else {
                if (query.getEntityToMatch().getEntityType() != Entity.GROUP) throw new IllegalArgumentException("You can only find the GROUP memberships of USER or GROUP");
                if (this.ldapPropertiesMapper.isNestedGroupsDisabled()) {
                    List list = Collections.emptyList();
                } else {
                    List<LDAPGroupWithAttributes> list = this.findGroupMembershipsOfGroupViaMemberDN(query.getEntityNameToMatch(), query.getEntityToReturn().getGroupType(), query.getStartIndex(), query.getMaxResults());
                }
            }
        }
        if (query.getReturnType() != String.class) return RFC4519Directory.toGenericList((List)var2_10);
        return RFC4519Directory.toGenericList(SearchResultsUtil.convertEntitiesToNames((List)var2_10));
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfUserViaMemberOf(String username, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        List results;
        block11: {
            try {
                LDAPUserWithAttributes user = this.findUserByName(username);
                Set<String> memberOfs = this.getMemberOfs(user);
                if (memberOfs != null) {
                    int totalResultSize;
                    if (maxResults == -1) {
                        results = new ArrayList<LDAPGroupWithAttributes>();
                        totalResultSize = -1;
                    } else {
                        results = new ArrayList<LDAPGroupWithAttributes>(maxResults);
                        totalResultSize = startIndex + maxResults;
                    }
                    for (String groupDN : memberOfs) {
                        try {
                            LDAPGroupWithAttributes entity = this.findEntityByDN(groupDN, LDAPGroupWithAttributes.class);
                            if (entity.getType() == groupType) {
                                results.add(entity);
                            }
                        }
                        catch (GroupNotFoundException e) {
                            // empty catch block
                        }
                        if (totalResultSize == -1 || results.size() < totalResultSize) continue;
                        break;
                    }
                    results = SearchResultsUtil.constrainResults(results, (int)startIndex, (int)maxResults);
                    break block11;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User with name <" + username + "> does not have any memberOf values and therefore has no memberships"));
                }
                results = Collections.emptyList();
            }
            catch (UserNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("User with name <" + username + "> does not exist and therefore has no memberships"));
                }
                results = Collections.emptyList();
            }
        }
        return results;
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfUserViaMemberDN(String username, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        try {
            LDAPUserWithAttributes user = this.findUserByName(username);
            return this.findGroupMembershipsOfEntityViaMemberDN(user.getDn(), groupType, startIndex, maxResults);
        }
        catch (UserNotFoundException e) {
            return Collections.emptyList();
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyList();
        }
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        try {
            LDAPGroupWithAttributes group = this.findGroupByNameAndType(groupName, groupType);
            return this.findGroupMembershipsOfEntityViaMemberDN(group.getDn(), groupType, startIndex, maxResults);
        }
        catch (GroupNotFoundException e) {
            return Collections.emptyList();
        }
    }

    private List<LDAPGroupWithAttributes> findGroupMembershipsOfEntityViaMemberDN(String dn, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        Name baseDN;
        ContextMapper contextMapper;
        AndFilter filter = new AndFilter();
        if (groupType == GroupType.GROUP) {
            filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getGroupFilter()));
            filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getGroupMemberAttribute(), dn));
            contextMapper = this.getGroupContextMapper(GroupType.GROUP);
            baseDN = this.searchDN.getGroup();
        } else if (groupType == GroupType.LEGACY_ROLE) {
            filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getRoleFilter()));
            filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getRoleMemberAttribute(), dn));
            contextMapper = this.getGroupContextMapper(GroupType.LEGACY_ROLE);
            baseDN = this.searchDN.getRole();
        } else {
            throw new IllegalArgumentException("Cannot find group memberships of entity via member DN for GroupType: " + groupType);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Executing search at DN: <" + this.searchDN.getGroup() + "> with filter: <" + filter.encode() + ">"));
        }
        return RFC4519Directory.toGenericList(this.searchEntities(baseDN, filter.encode(), contextMapper, startIndex, maxResults));
    }

    private List<LDAPGroupWithAttributes> findGroupMembersOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        return this.findMembersOfGroupViaMemberDN(groupName, groupType, LDAPGroupWithAttributes.class, startIndex, maxResults);
    }

    private List<LDAPUserWithAttributes> findUserMembersOfGroupViaMemberDN(String groupName, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        return this.findMembersOfGroupViaMemberDN(groupName, groupType, LDAPUserWithAttributes.class, startIndex, maxResults);
    }

    private List<LDAPUserWithAttributes> findUserMembersOfGroupViaMemberOf(String groupName, GroupType groupType, int startIndex, int maxResults) throws OperationFailedException {
        List<LDAPUserWithAttributes> results;
        try {
            LDAPGroupWithAttributes group = this.findGroupWithAttributesByName(groupName);
            if (group.getType() == groupType) {
                AndFilter filter = new AndFilter();
                filter.and((Filter)new HardcodedFilter(this.ldapPropertiesMapper.getUserFilter()));
                filter.and((Filter)new EqualsFilter(this.ldapPropertiesMapper.getUserGroupMembershipsAttribute(), group.getDn()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing search at DN: <" + this.searchDN.getUser() + "> with filter: <" + filter.encode() + ">"));
                }
                results = RFC4519Directory.toGenericList(this.searchEntities(this.searchDN.getUser(), filter.encode(), this.getUserContextMapper(), startIndex, maxResults));
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Group with name <" + groupName + "> does exist but is of GroupType <" + group.getType() + "> and not <" + groupType + ">"));
                }
                results = Collections.emptyList();
            }
        }
        catch (GroupNotFoundException e) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Group with name <" + groupName + "> does not exist and therefore has no members"));
            }
            results = Collections.emptyList();
        }
        return results;
    }

    private <T extends LDAPDirectoryEntity> List<T> findMembersOfGroupViaMemberDN(String groupName, GroupType groupType, Class<T> memberClass, int startIndex, int maxResults) throws OperationFailedException {
        List results;
        block14: {
            try {
                LDAPGroupWithAttributes group = this.findGroupByNameAndType(groupName, groupType);
                Set<String> memberDNs = this.getMemberDNs(group);
                if (memberDNs != null) {
                    int totalResultSize;
                    if (maxResults == -1) {
                        results = new ArrayList();
                        totalResultSize = -1;
                    } else {
                        results = new ArrayList(maxResults);
                        totalResultSize = startIndex + maxResults;
                    }
                    for (String memberDN : memberDNs) {
                        try {
                            T entity = this.findEntityByDN(memberDN, memberClass);
                            if (entity instanceof LDAPGroupWithAttributes) {
                                if (((LDAPGroupWithAttributes)entity).getType() == groupType) {
                                    results.add(entity);
                                }
                            } else {
                                results.add(entity);
                            }
                        }
                        catch (UserNotFoundException e) {
                        }
                        catch (GroupNotFoundException e) {
                            // empty catch block
                        }
                        if (totalResultSize == -1 || results.size() < totalResultSize) continue;
                        break;
                    }
                    results = SearchResultsUtil.constrainResults(results, (int)startIndex, (int)maxResults);
                    break block14;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Group with name <" + groupName + "> does not have any memberDNs and therefore has no members"));
                }
                results = Collections.emptyList();
            }
            catch (GroupNotFoundException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Group with name <" + groupName + "> does not exist and therefore has no members"));
                }
                results = Collections.emptyList();
            }
        }
        return results;
    }

    private static <T> List<T> toGenericList(List list) {
        return list;
    }
}

