/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC4519Directory;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import javax.naming.directory.Attributes;
import org.apache.log4j.Logger;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.support.LdapContextSource;

public class SunONE
extends RFC4519Directory {
    private static final Logger logger = Logger.getLogger(SunONE.class);

    public SunONE(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
    }

    public static String getStaticDirectoryType() {
        return "Sun Directory Server Enterprise Edition";
    }

    public String getDescriptiveName() {
        return SunONE.getStaticDirectoryType();
    }

    @Override
    protected String encodePassword(String unencodedPassword) {
        return unencodedPassword;
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, "");
    }

    protected LdapTemplate createChangeListenerTemplate() {
        LdapContextSource contextSource = new LdapContextSource();
        contextSource.setUrl(this.ldapPropertiesMapper.getConnectionURL());
        contextSource.setUserDn(this.ldapPropertiesMapper.getUsername());
        contextSource.setPassword(this.ldapPropertiesMapper.getPassword());
        contextSource.setBaseEnvironmentProperties(this.getBaseEnvironmentProperties());
        contextSource.setPooled(true);
        contextSource.setDirObjectFactory(null);
        try {
            contextSource.afterPropertiesSet();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        return new LdapTemplate((ContextSource)contextSource);
    }
}

