/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory;

import com.atlassian.crowd.directory.RFC2307Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.InvalidUserException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotSupportedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.password.encoder.PasswordEncoder;
import com.atlassian.crowd.password.factory.PasswordEncoderFactory;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.event.api.EventPublisher;
import javax.naming.directory.Attributes;
import org.apache.commons.lang.StringUtils;

public class Rfc2307
extends RFC2307Directory {
    private final PasswordEncoderFactory passwordEncoderFactory;

    public Rfc2307(LDAPQueryTranslater ldapQueryTranslater, EventPublisher eventPublisher, InstanceFactory instanceFactory, PasswordEncoderFactory passwordEncoderFactory) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
        this.passwordEncoderFactory = passwordEncoderFactory;
    }

    public static String getStaticDirectoryType() {
        return "Generic Posix/RFC2307 Directory (Read-Only)";
    }

    @Override
    protected String encodePassword(String unencodedPassword) {
        if (unencodedPassword == null) {
            return null;
        }
        String encryptionAlgorithm = this.ldapPropertiesMapper.getUserEncryptionMethod();
        if (!StringUtils.isBlank((String)encryptionAlgorithm)) {
            PasswordEncoder passwordEncoder = this.passwordEncoderFactory.getLdapEncoder(encryptionAlgorithm);
            return passwordEncoder.encodePassword(unencodedPassword, null);
        }
        return unencodedPassword;
    }

    @Override
    protected void getNewUserDirectorySpecificAttributes(User user, Attributes attributes) {
        this.addDefaultSnToUserAttributes(attributes, user.getName());
    }

    public String getDescriptiveName() {
        return Rfc2307.getStaticDirectoryType();
    }

    public void addUserToGroup(String username, String groupName) throws UserNotFoundException, GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    public void addGroupToGroup(String childGroup, String parentGroup) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    public void removeUserFromGroup(String username, String groupName) throws UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    public void removeGroupFromGroup(String childGroup, String parentGroup) throws GroupNotFoundException, MembershipNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public LDAPUserWithAttributes addUser(UserTemplate user, PasswordCredential credential) throws InvalidUserException, InvalidCredentialException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public Group addGroup(GroupTemplate group) throws InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public Group renameGroup(String oldName, String newName) throws GroupNotFoundException, InvalidGroupException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public User renameUser(String oldName, String newName) throws UserNotFoundException, InvalidUserException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public Group updateGroup(GroupTemplate group) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public User updateUser(UserTemplate user) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public void removeUser(String name) throws UserNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }

    @Override
    public void removeGroup(String name) throws GroupNotFoundException, OperationFailedException {
        throw new OperationNotSupportedException("POSIX support is currently read-only");
    }
}

