/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.Date;
import java.util.List;
import org.apache.log4j.Logger;

public class RemoteDirectoryCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = Logger.getLogger(RemoteDirectoryCacheRefresher.class);

    public RemoteDirectoryCacheRefresher(RemoteDirectory remoteDirectory) {
        super(remoteDirectory);
    }

    @Override
    public boolean synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        return false;
    }

    private List<User> findAllRemoteUsers() throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug((Object)"loading remote users");
        List users = this.remoteDirectory.searchUsers(QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
        log.info((Object)("found [ " + users.size() + " ] remote users in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return users;
    }

    private List<Group> findAllRemoteGroups(GroupType groupType) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug((Object)"loading remote groups");
        List groups = this.remoteDirectory.searchGroups(QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group((GroupType)groupType)).returningAtMost(-1));
        log.info((Object)("found [ " + groups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return groups;
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<User> ldapUsers = this.findAllRemoteUsers();
        directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
        directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(GroupType groupType, DirectoryCache directoryCache) throws OperationFailedException {
        Date syncStartDate = new Date();
        List<Group> ldapGroups = this.findAllRemoteGroups(groupType);
        directoryCache.addOrUpdateCachedGroups(ldapGroups, syncStartDate);
        directoryCache.deleteCachedGroupsNotIn(groupType, ldapGroups, syncStartDate);
        return ldapGroups;
    }
}

