/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.MicrosoftActiveDirectory;
import com.atlassian.crowd.directory.ldap.cache.AbstractCacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.directory.ldap.cache.LDAPEntityNameMap;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.model.Tombstone;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.model.group.LDAPGroupWithAttributes;
import com.atlassian.crowd.model.user.LDAPUserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UsnChangedCacheRefresher
extends AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = Logger.getLogger(UsnChangedCacheRefresher.class);
    private static final long UNINITIALISED = -1L;
    private final MicrosoftActiveDirectory activeDirectory;
    private volatile long highestCommittedUSN = -1L;
    private final LDAPEntityNameMap<LDAPUserWithAttributes> userMap = new LDAPEntityNameMap();
    private final LDAPEntityNameMap<LDAPGroupWithAttributes> groupMap = new LDAPEntityNameMap();
    private Future<List<LDAPUserWithAttributes>> userListFuture;
    private Future<List<LDAPGroupWithAttributes>> groupListFuture;
    private Future<List<LDAPGroupWithAttributes>> roleListFuture;

    public UsnChangedCacheRefresher(MicrosoftActiveDirectory activeDirectory) {
        super(activeDirectory);
        this.activeDirectory = activeDirectory;
    }

    @Override
    public boolean canSynchroniseChanges() {
        return this.highestCommittedUSN != -1L && this.activeDirectory.isRolesDisabled();
    }

    @Override
    protected void synchroniseMembershipsForGroup(GroupType groupType, Group group, DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        LDAPGroupWithAttributes ldapGroup = (LDAPGroupWithAttributes)group;
        Set<String> dnList = ldapGroup.getValues("memberDNs");
        ArrayList<String> ldapUsers = new ArrayList<String>();
        ArrayList<String> ldapSubGroups = new ArrayList<String>();
        for (String dn : dnList) {
            String userMember = this.userMap.getByDn(dn);
            String groupMember = this.groupMap.getByDn(dn);
            if (userMember == null && groupMember == null) {
                LDAPUserWithAttributes userObj = this.findRemoteUser(dn);
                if (userObj != null) {
                    userMember = userObj.getName();
                } else {
                    LDAPGroupWithAttributes groupObj = this.findRemoteGroup(dn);
                    if (groupObj != null) {
                        groupMember = groupObj.getName();
                    }
                }
            }
            if (userMember != null) {
                ldapUsers.add(userMember);
            }
            if (groupMember == null) continue;
            ldapSubGroups.add(groupMember);
        }
        log.info((Object)("found [ " + ldapUsers.size() + " ] remote user-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        log.info((Object)("found [ " + ldapSubGroups.size() + " ] remote group-group memberships in [ 0ms ]"));
        directoryCache.syncUserMembershipsForGroup((Group)ldapGroup, ldapUsers);
        directoryCache.syncGroupMembershipsForGroup((Group)ldapGroup, ldapSubGroups);
    }

    private LDAPGroupWithAttributes findRemoteGroup(String dn) throws OperationFailedException {
        try {
            return this.activeDirectory.findEntityByDN(dn, LDAPGroupWithAttributes.class);
        }
        catch (GroupNotFoundException e) {
            return null;
        }
        catch (UserNotFoundException e) {
            throw new AssertionError((Object)"Should not throw UserNotFoundException");
        }
    }

    private LDAPUserWithAttributes findRemoteUser(String dn) throws OperationFailedException {
        try {
            return this.activeDirectory.findEntityByDN(dn, LDAPUserWithAttributes.class);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (GroupNotFoundException e) {
            throw new AssertionError((Object)"Should not throw GroupNotFoundException");
        }
    }

    @Override
    public void synchroniseChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
        this.synchroniseUserChanges(directoryCache);
        this.synchroniseGroupChanges(directoryCache);
        this.highestCommittedUSN = currentHighestCommittedUSN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        ExecutorService queryExecutor = Executors.newFixedThreadPool(3);
        try {
            this.userListFuture = queryExecutor.submit(new Callable<List<LDAPUserWithAttributes>>(){

                @Override
                public List<LDAPUserWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug((Object)"loading remote users");
                    List<LDAPUserWithAttributes> ldapUsers = UsnChangedCacheRefresher.this.activeDirectory.searchUsers(QueryBuilder.queryFor(LDAPUserWithAttributes.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1));
                    log.info((Object)("found [ " + ldapUsers.size() + " ] remote users in [ " + (System.currentTimeMillis() - start) + "ms ]"));
                    return ldapUsers;
                }
            });
            this.groupListFuture = queryExecutor.submit(new Callable<List<LDAPGroupWithAttributes>>(){

                @Override
                public List<LDAPGroupWithAttributes> call() throws Exception {
                    long start = System.currentTimeMillis();
                    log.debug((Object)"loading remote groups");
                    List<LDAPGroupWithAttributes> ldapGroups = UsnChangedCacheRefresher.this.activeDirectory.searchGroups(QueryBuilder.queryFor(LDAPGroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.GROUP)).returningAtMost(-1));
                    log.info((Object)("found [ " + ldapGroups.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]"));
                    return ldapGroups;
                }
            });
            this.roleListFuture = queryExecutor.submit(new Callable<List<LDAPGroupWithAttributes>>(){

                @Override
                public List<LDAPGroupWithAttributes> call() throws Exception {
                    List ldapRoles = null;
                    if (!UsnChangedCacheRefresher.this.activeDirectory.isRolesDisabled()) {
                        long start = System.currentTimeMillis();
                        log.debug((Object)"loading remote roles");
                        ldapRoles = UsnChangedCacheRefresher.this.activeDirectory.searchGroups(QueryBuilder.queryFor(LDAPGroupWithAttributes.class, (EntityDescriptor)EntityDescriptor.group((GroupType)GroupType.LEGACY_ROLE)).returningAtMost(-1));
                        log.info((Object)("found [ " + ldapRoles.size() + " ] remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]"));
                    } else {
                        log.debug((Object)"roles disabled, not loading remote roles");
                    }
                    return ldapRoles;
                }
            });
            long currentHighestCommittedUSN = this.activeDirectory.fetchHighestCommittedUSN();
            super.synchroniseAll(directoryCache);
            this.highestCommittedUSN = currentHighestCommittedUSN;
        }
        finally {
            queryExecutor.shutdown();
            this.userListFuture = null;
            this.groupListFuture = null;
            this.roleListFuture = null;
        }
    }

    @Override
    protected void synchroniseAllUsers(DirectoryCache directoryCache) throws OperationFailedException {
        this.userMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPUserWithAttributes> ldapUsers = this.userListFuture.get();
            for (LDAPUserWithAttributes ldapUser : ldapUsers) {
                this.userMap.put(ldapUser);
            }
            directoryCache.addOrUpdateCachedUsers(ldapUsers, syncStartDate);
            directoryCache.deleteCachedUsersNotIn(ldapUsers, syncStartDate);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected List<? extends Group> synchroniseAllGroups(GroupType groupType, DirectoryCache directoryCache) throws OperationFailedException {
        this.groupMap.clear();
        Date syncStartDate = new Date();
        try {
            List<LDAPGroupWithAttributes> ldapGroups = groupType == GroupType.GROUP ? this.groupListFuture.get() : this.roleListFuture.get();
            for (LDAPGroupWithAttributes ldapGroup : ldapGroups) {
                this.groupMap.put(ldapGroup);
            }
            directoryCache.addOrUpdateCachedGroups(ldapGroups, syncStartDate);
            directoryCache.deleteCachedGroupsNotIn(groupType, ldapGroups, syncStartDate);
            return ldapGroups;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new OperationFailedException("background query interrupted", (Throwable)e);
        }
        catch (ExecutionException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private void synchroniseUserChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug((Object)"loading changed remote users");
        List<LDAPUserWithAttributes> updatedUsers = this.activeDirectory.findAddedOrUpdatedUsersSince(this.highestCommittedUSN);
        List<Tombstone> tombstones = this.activeDirectory.findUserTombstonesSince(this.highestCommittedUSN);
        log.info((Object)("found [ " + (updatedUsers.size() + tombstones.size()) + " ] changed remote users in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        for (LDAPUserWithAttributes user : updatedUsers) {
            this.userMap.put(user);
        }
        directoryCache.addOrUpdateCachedUsers(updatedUsers, null);
        start = System.currentTimeMillis();
        HashSet<String> usernames = new HashSet<String>();
        for (Tombstone tombstone : tombstones) {
            String username = this.userMap.getByGuid(tombstone.getObjectGUID());
            if (username == null) continue;
            usernames.add(username);
        }
        log.info((Object)("scanned and compared [ " + tombstones.size() + " ] groups for delete in DB cache in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        directoryCache.deleteCachedUsers(usernames);
    }

    private void synchroniseGroupChanges(DirectoryCache directoryCache) throws OperationFailedException {
        long start = System.currentTimeMillis();
        log.debug((Object)"loading changed remote groups");
        List<LDAPGroupWithAttributes> updatedGroups = this.activeDirectory.findAddedOrUpdatedGroupsSince(this.highestCommittedUSN);
        List<Tombstone> tombstones = this.activeDirectory.findGroupTombstonesSince(this.highestCommittedUSN);
        log.info((Object)("found [ " + (updatedGroups.size() + tombstones.size()) + " ] changed remote groups in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        for (LDAPGroupWithAttributes group : updatedGroups) {
            this.groupMap.put(group);
        }
        directoryCache.addOrUpdateCachedGroups(updatedGroups, null);
        this.synchroniseMemberships(GroupType.GROUP, updatedGroups, directoryCache);
        start = System.currentTimeMillis();
        HashSet<String> groupnames = new HashSet<String>();
        for (Tombstone tombstone : tombstones) {
            String groupName = this.groupMap.getByGuid(tombstone.getObjectGUID());
            if (groupName == null) continue;
            groupnames.add(groupName);
        }
        log.info((Object)("scanned and compared [ " + tombstones.size() + " ] groups for delete in DB cache in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        directoryCache.deleteCachedGroups(groupnames);
    }
}

