/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.cache;

import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.ldap.cache.CacheRefresher;
import com.atlassian.crowd.directory.ldap.cache.DirectoryCache;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupType;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCacheRefresher
implements CacheRefresher {
    private static final Logger log = Logger.getLogger(AbstractCacheRefresher.class);
    static final int MEMBERSHIP_LOG_FREQUENCY = 5;
    protected final RemoteDirectory remoteDirectory;

    public AbstractCacheRefresher(RemoteDirectory remoteDirectory) {
        this.remoteDirectory = remoteDirectory;
    }

    @Override
    public void synchroniseAll(DirectoryCache directoryCache) throws OperationFailedException {
        this.synchroniseAllUsers(directoryCache);
        List<? extends Group> allGroups = this.synchroniseAllGroups(GroupType.GROUP, directoryCache);
        this.synchroniseMemberships(GroupType.GROUP, allGroups, directoryCache);
        if (!this.remoteDirectory.isRolesDisabled()) {
            List<? extends Group> allRoles = this.synchroniseAllGroups(GroupType.LEGACY_ROLE, directoryCache);
            this.synchroniseMemberships(GroupType.LEGACY_ROLE, allRoles, directoryCache);
        }
    }

    protected abstract void synchroniseAllUsers(DirectoryCache var1) throws OperationFailedException;

    protected abstract List<? extends Group> synchroniseAllGroups(GroupType var1, DirectoryCache var2) throws OperationFailedException;

    protected void synchroniseMemberships(GroupType groupType, List<? extends Group> remoteGroups, DirectoryCache directoryCache) throws OperationFailedException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Updating memberships for " + remoteGroups.size() + " " + groupType.name() + "s from " + this.directoryDescription()));
        }
        int total = remoteGroups.size();
        int logEvery = total / 5;
        for (int i = 0; i < total; ++i) {
            this.synchroniseMembershipsForGroup(groupType, remoteGroups.get(i), directoryCache);
            if (logEvery != 0 && i % logEvery != 0) continue;
            log.info((Object)("Migrated memberships for [" + i + "] of [" + total + "] groups"));
        }
    }

    private List<String> findAllUserMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info((Object)("found [ " + names.size() + " ] remote user-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return names;
    }

    private List<String> findAllGroupMembersOfGroup(String name, GroupType type) throws OperationFailedException {
        long start = System.currentTimeMillis();
        List names = this.remoteDirectory.searchGroupRelationships(QueryBuilder.queryFor(String.class, (EntityDescriptor)EntityDescriptor.group((GroupType)type)).childrenOf(EntityDescriptor.group((GroupType)type)).withName(name).returningAtMost(-1));
        log.info((Object)("found [ " + names.size() + " ] remote group-group memberships in [ " + (System.currentTimeMillis() - start) + "ms ]"));
        return names;
    }

    protected void synchroniseMembershipsForGroup(GroupType groupType, Group ldapGroup, DirectoryCache directoryCache) throws OperationFailedException {
        List<String> ldapUsers = this.findAllUserMembersOfGroup(ldapGroup.getName(), groupType);
        directoryCache.syncUserMembershipsForGroup(ldapGroup, ldapUsers);
        if (this.remoteDirectory.supportsNestedGroups()) {
            List<String> ldapSubGroups = this.findAllGroupMembersOfGroup(ldapGroup.getName(), groupType);
            directoryCache.syncGroupMembershipsForGroup(ldapGroup, ldapSubGroups);
        }
    }

    protected String directoryDescription() {
        return this.remoteDirectory.getDescriptiveName() + " Directory " + this.remoteDirectory.getDirectoryId();
    }
}

