/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.directory.ldap.mapper.attribute.group;

import com.atlassian.crowd.directory.ldap.mapper.attribute.AttributeMapper;
import com.atlassian.crowd.directory.ldap.util.RangeOption;
import java.util.HashSet;
import java.util.Set;
import javax.naming.NamingEnumeration;
import org.springframework.ldap.core.DirContextAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RFC4519MemberDnRangeOffsetMapper
implements AttributeMapper {
    public static final String ATTRIBUTE_KEY = "memberRangeStart";
    private final String groupMemberAttribute;

    public RFC4519MemberDnRangeOffsetMapper(String groupMemberAttribute) {
        this.groupMemberAttribute = groupMemberAttribute;
    }

    @Override
    public String getKey() {
        return ATTRIBUTE_KEY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getValues(DirContextAdapter ctx) throws Exception {
        HashSet<String> attributes = new HashSet<String>();
        NamingEnumeration<String> attrEnum = ctx.getAttributes().getIDs();
        try {
            while (attrEnum.hasMore()) {
                String attrId = attrEnum.next();
                if (!attrId.startsWith(this.groupMemberAttribute + ";")) continue;
                RangeOption range = RangeOption.parse(attrId.split(";")[1]);
                int newStart = range.getTerminal() + 1;
                attributes.add(String.valueOf(newStart));
                break;
            }
        }
        finally {
            attrEnum.close();
        }
        return attributes;
    }
}

