package com.atlassian.crowd.search.ldap.filter;

import com.atlassian.crowd.directory.ldap.util.GuidHelper;

/**
 * A filter for ObjectGUID attribute. Constructs a byte string form suitable for search.
 * Implemented to perform a query against AD - <em>not</em> tested with other directories.
 * (See http://forum.spring.io/forum/spring-projects/data/ldap/38332-search-using-objectguid for details)
 */
public class EqualsExternalIdFilter extends org.springframework.ldap.filter.EqualsFilter {

    public EqualsExternalIdFilter(String attribute, String value) {
        super(attribute, value);
    }

    /**
     * Encodes value as byte String.
     *
     * @param value ObjectGUID string as returned by {@link com.atlassian.crowd.directory.ldap.util.GuidHelper#getGUIDAsString(byte[])}
     * @return byte string form suitable for search
     * @see GuidHelper#encodeGUIDForSearch(String)
     */
    @Override
    protected String encodeValue(String value) {
        return GuidHelper.encodeGUIDForSearch(value);
    }
}
