package com.atlassian.crowd.directory.ldap.name;

import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;

/**
 * Converts a string name into a Name, for use with spring-ldap.
 */
public interface Converter {
    /**
     * Escapes and converts a DN into a Name, for use with LDAP through JNDI.
     */
    LdapName getName(String dn) throws InvalidNameException;

    /**
     * Returns a Name escaped for JNDI and LDAP, for use with a directory. Used when building a DN from an object name
     * plus directory configuration information
     *
     * Given:
     * attributeName: "cn"
     * objectName: "Smith, John"
     * baseDN: "dc=example, dc=org"
     * It will return a Name that represents the DN:
     * "cn=Smith\, John, dc=example, dc=org"
     *
     * @param baseDN A correctly-escaped DN. May be empty or null.
     */
    LdapName getName(String attributeName, String objectName, LdapName baseDN) throws InvalidNameException;
}
