package com.atlassian.crowd.directory.ldap.mapper;

import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingException;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;

import org.springframework.ldap.core.CollectingNameClassPairCallbackHandler;
import org.springframework.ldap.core.DirContextAdapter;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public class LookupCallbackHandler<T> extends CollectingNameClassPairCallbackHandler<T> {
    @Override
    @SuppressFBWarnings(value = "LDAP_INJECTION", justification = "No user input")
    public T getObjectFromNameClassPair(NameClassPair nameClassPair) throws NamingException {
        if (!(nameClassPair instanceof Binding)) {
            throw new IllegalArgumentException("Parameter must be an instance of Binding");
        }

        Binding binding = (Binding) nameClassPair;
        Object object = binding.getObject();
        if (object == null) {
            object = new DirContextAdapter(((SearchResult) nameClassPair).getAttributes(),
                    new LdapName(nameClassPair.getNameInNamespace()));
        }
        return (T) object;
    }
}
