package com.atlassian.crowd.directory;

import javax.naming.directory.Attributes;

import com.atlassian.crowd.directory.ldap.credential.EnforceUnencryptedCredentialEncoder;
import com.atlassian.crowd.directory.ldap.credential.LDAPCredentialEncoder;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.search.ldap.LDAPQueryTranslater;
import com.atlassian.crowd.util.InstanceFactory;
import com.atlassian.crowd.util.PasswordHelper;
import com.atlassian.event.api.EventPublisher;

/**
 * Novell eDirectory LDAP connector.
 */
public class NovelleDirectory extends RFC4519Directory {
    private final LDAPCredentialEncoder credentialEncoder;

    /**
     * @param passwordHelper password helper, which must not be null
     */
    public NovelleDirectory(LDAPQueryTranslater ldapQueryTranslater,
                            EventPublisher eventPublisher,
                            InstanceFactory instanceFactory,
                            PasswordHelper passwordHelper) {
        super(ldapQueryTranslater, eventPublisher, instanceFactory);
        // Novell eDirectory doesn't want passwords encoded before they're passed to the directory.
        //  (or at least, we don't currently support it)
        credentialEncoder = new EnforceUnencryptedCredentialEncoder(passwordHelper);
    }

    public static String getStaticDirectoryType() {
        return "Novell eDirectory Server";
    }

    @Override
    public String getDescriptiveName() {
        return NovelleDirectory.getStaticDirectoryType();
    }

    @Override
    protected LDAPCredentialEncoder getCredentialEncoder() {
        return credentialEncoder;
    }

    /**
     * Novell eDirectory in a default install requires the sn to be set before a user can be created.
     */
    @Override
    protected void getNewUserDirectorySpecificAttributes(final User user, final Attributes attributes) {
        addDefaultSnToUserAttributes(attributes, user.getName());
    }
}