package com.atlassian.crowd.console.value.directory;

import java.util.concurrent.TimeUnit;

import com.atlassian.crowd.directory.ldap.LDAPPropertiesMapper;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.model.directory.DirectoryImpl;

public class ConnectorConnection extends SynchronisableDirectoryConnection {
    // Timeout value are displayed to users as seconds, but stored as milliseconds
    private long readTimeoutInSec = 120;
    private long searchTimeoutInSec = 60;
    private long connectionTimeoutInSec = 10;

    public long getReadTimeoutInSec() {
        return readTimeoutInSec;
    }

    public void setReadTimeoutInSec(long readTimeoutInSec) {
        this.readTimeoutInSec = readTimeoutInSec;
    }

    public long getSearchTimeoutInSec() {
        return searchTimeoutInSec;
    }

    public void setSearchTimeoutInSec(long searchTimeoutInSec) {
        this.searchTimeoutInSec = searchTimeoutInSec;
    }

    public long getConnectionTimeoutInSec() {
        return connectionTimeoutInSec;
    }

    public void setConnectionTimeoutInSec(long connectionTimeoutInSec) {
        this.connectionTimeoutInSec = connectionTimeoutInSec;
    }

    @Override
    public void loadFromDirectory(Directory directory) {
        super.loadFromDirectory(directory);

        // timeout values are stored internally in milliseconds, but we want to display it as seconds to the user
        setReadTimeoutInSec(TimeUnit.SECONDS.convert(getAttributeValueAsLong(directory, LDAPPropertiesMapper.LDAP_READ_TIMEOUT), TimeUnit.MILLISECONDS));
        setSearchTimeoutInSec(TimeUnit.SECONDS.convert(getAttributeValueAsLong(directory, LDAPPropertiesMapper.LDAP_SEARCH_TIMELIMIT), TimeUnit.MILLISECONDS));
        setConnectionTimeoutInSec(TimeUnit.SECONDS.convert(getAttributeValueAsLong(directory, LDAPPropertiesMapper.LDAP_CONNECTION_TIMEOUT), TimeUnit.MILLISECONDS));
    }

    @Override
    public void updateDirectory(DirectoryImpl directory) {
        super.updateDirectory(directory);

        // set connection pool properties - convert from seconds to milliseconds to store
        directory.setAttribute(LDAPPropertiesMapper.LDAP_READ_TIMEOUT, Long.toString(TimeUnit.MILLISECONDS.convert(readTimeoutInSec, TimeUnit.SECONDS)));
        directory.setAttribute(LDAPPropertiesMapper.LDAP_SEARCH_TIMELIMIT, Long.toString(TimeUnit.MILLISECONDS.convert(searchTimeoutInSec, TimeUnit.SECONDS)));
        directory.setAttribute(LDAPPropertiesMapper.LDAP_CONNECTION_TIMEOUT, Long.toString(TimeUnit.MILLISECONDS.convert(connectionTimeoutInSec, TimeUnit.SECONDS)));
    }

}
