/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.embedded.api.Attributes;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.google.common.base.MoreObjects;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nullable;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class CrowdUserDetails
implements UserDetails {
    private static final Attributes EMPTY_ATTRIBUTES = new EmptyAttributes();
    private final User principal;
    private final Attributes attributes;
    private final Collection<GrantedAuthority> authorities;

    public CrowdUserDetails(User principal, Collection<GrantedAuthority> authorities) {
        this(principal, EMPTY_ATTRIBUTES, authorities);
    }

    public CrowdUserDetails(UserWithAttributes principal, Collection<GrantedAuthority> authorities) {
        this((User)principal, (Attributes)principal, authorities);
    }

    private CrowdUserDetails(User principal, Attributes attributes, Collection<GrantedAuthority> authorities) {
        this.principal = principal;
        this.attributes = attributes;
        this.authorities = (Collection)MoreObjects.firstNonNull(authorities, Collections.emptySet());
    }

    public Collection<GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public User getRemotePrincipal() {
        return this.principal;
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Not giving you the password");
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.principal.isActive();
    }

    public String getFirstName() {
        return this.principal.getFirstName();
    }

    public String getLastName() {
        return this.principal.getLastName();
    }

    public String getEmail() {
        return this.principal.getEmailAddress();
    }

    public String getAttribute(String attributeName) {
        return this.attributes.getValue(attributeName);
    }

    public String getFullName() {
        return this.principal.getDisplayName();
    }

    private static class EmptyAttributes
    implements Attributes {
        private EmptyAttributes() {
        }

        public Set<String> getKeys() {
            return Collections.emptySet();
        }

        @Nullable
        public String getValue(String arg0) {
            return null;
        }

        public Set<String> getValues(String arg0) {
            return Collections.emptySet();
        }

        public boolean isEmpty() {
            return true;
        }
    }
}

