/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity.user;

import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdDataAccessException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.service.AuthenticationManager;
import com.atlassian.crowd.service.GroupMembershipManager;
import com.atlassian.crowd.service.UserManager;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class CrowdUserDetailsServiceImpl
implements CrowdUserDetailsService {
    private UserManager userManager;
    private AuthenticationManager authenticationManager;
    private GroupMembershipManager groupMembershipManager;
    private String authorityPrefix = "";
    private String authoritySuffix = null;

    @Override
    public CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUser(username);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new CrowdDataAccessException(e);
        }
        catch (UserNotFoundException e) {
            throw new UsernameNotFoundException("Could not find principal in Crowd with username: " + username, (Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
    }

    @Override
    public CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        try {
            SOAPPrincipal principal = this.userManager.getUserFromToken(token);
            return new CrowdUserDetails(principal, this.getAuthorities(principal.getName()));
        }
        catch (InvalidAuthorizationTokenException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw new CrowdDataAccessException(e);
        }
        catch (UsernameNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (InvalidTokenException e) {
            throw new CrowdSSOTokenInvalidException(e.getMessage(), e);
        }
        catch (InvalidAuthenticationException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
        catch (UserNotFoundException e) {
            throw new CrowdDataAccessException((Exception)((Object)e));
        }
    }

    List<GrantedAuthority> getAuthorities(String username) throws InvalidAuthorizationTokenException, RemoteException, UserNotFoundException, InvalidAuthenticationException {
        List<GrantedAuthority> authorities;
        if (this.authoritySuffix == null) {
            List userGroups = this.groupMembershipManager.getMemberships(username);
            authorities = this.generateAuthoritiesFromGroupNames(userGroups);
        } else {
            List<String> authorizedGroups = Arrays.asList(this.authenticationManager.getSecurityServerClient().getGrantedAuthorities());
            authorities = this.generateAuthorityFromSuffix(username, authorizedGroups);
        }
        return authorities;
    }

    private List<GrantedAuthority> generateAuthorityFromSuffix(String username, List<String> authorizedGroups) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String group : authorizedGroups) {
            if (!this.groupMembershipManager.isMember(username, group)) continue;
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.getAuthorityPrefix() + this.getAuthoritySuffix()));
            break;
        }
        return authorities;
    }

    private List<GrantedAuthority> generateAuthoritiesFromGroupNames(List userGroups) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        Iterator iterator = userGroups.iterator();
        while (iterator.hasNext()) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(this.getAuthorityPrefix() + iterator.next()));
        }
        return authorities;
    }

    @Override
    public String getAuthorityPrefix() {
        return this.authorityPrefix;
    }

    @Override
    public void setAuthorityPrefix(String authorityPrefix) {
        this.authorityPrefix = authorityPrefix;
    }

    @Override
    public String getAuthoritySuffix() {
        return this.authoritySuffix;
    }

    @Override
    public void setAuthoritySuffix(String authoritySuffix) {
        this.authoritySuffix = authoritySuffix;
    }

    public void setUserManager(UserManager userManager) {
        this.userManager = userManager;
    }

    public void setGroupMembershipManager(GroupMembershipManager groupMembershipManager) {
        this.groupMembershipManager = groupMembershipManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

