/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.springsecurity.CrowdAuthenticationProvider;
import com.atlassian.crowd.integration.springsecurity.CrowdSSOTokenInvalidException;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetails;
import com.atlassian.crowd.integration.springsecurity.user.CrowdUserDetailsService;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.AuthenticationManager;
import java.rmi.RemoteException;
import org.springframework.dao.DataAccessException;
import org.springframework.security.userdetails.UsernameNotFoundException;

public class RemoteCrowdAuthenticationProvider
extends CrowdAuthenticationProvider {
    protected final AuthenticationManager authenticationManager;
    protected final HttpAuthenticator httpAuthenticator;
    protected final CrowdUserDetailsService userDetailsService;

    public RemoteCrowdAuthenticationProvider(AuthenticationManager authenticationManager, HttpAuthenticator httpAuthenticator, CrowdUserDetailsService userDetailsService) {
        super(httpAuthenticator.getSoapClientProperties().getApplicationName());
        this.authenticationManager = authenticationManager;
        this.httpAuthenticator = httpAuthenticator;
        this.userDetailsService = userDetailsService;
    }

    @Override
    protected boolean isAuthenticated(String token, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException, InvalidAuthenticationException {
        return this.authenticationManager.isAuthenticated(token, validationFactors);
    }

    @Override
    protected String authenticate(String username, String password, ValidationFactor[] validationFactors) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException {
        return this.httpAuthenticator.verifyAuthentication(username, password, validationFactors);
    }

    @Override
    protected CrowdUserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        return this.userDetailsService.loadUserByUsername(username);
    }

    @Override
    protected CrowdUserDetails loadUserByToken(String token) throws CrowdSSOTokenInvalidException, DataAccessException {
        return this.userDetailsService.loadUserByToken(token);
    }
}

