/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.springsecurity;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class CrowdLogoutHandler
implements LogoutHandler {
    private static final Logger logger = LoggerFactory.getLogger(CrowdLogoutHandler.class);
    private HttpAuthenticator httpAuthenticator;

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        try {
            this.httpAuthenticator.logoff(request, response);
        }
        catch (Exception e) {
            logger.error("Could not logout SSO user from Crowd", (Throwable)e);
        }
    }

    public HttpAuthenticator getHttpAuthenticator() {
        return this.httpAuthenticator;
    }

    public void setHttpAuthenticator(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }
}

