/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.seraph.v22;

import com.atlassian.crowd.integration.http.CrowdHttpAuthenticator;
import com.atlassian.crowd.integration.rest.service.factory.RestCrowdHttpAuthenticationFactory;
import com.atlassian.crowd.integration.seraph.v22.CrowdAuthenticator;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.user.EntityException;
import com.atlassian.user.UserManager;
import java.security.Principal;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.Authentication;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.context.SecurityContextHolder;
import org.acegisecurity.providers.anonymous.AnonymousAuthenticationToken;
import org.acegisecurity.ui.AuthenticationDetailsSourceImpl;

public class BambooAuthenticator
extends CrowdAuthenticator {
    public BambooAuthenticator() {
        super(RestCrowdHttpAuthenticationFactory.getAuthenticator());
    }

    public BambooAuthenticator(CrowdHttpAuthenticator crowdHttpAuthenticator) {
        super(crowdHttpAuthenticator);
    }

    protected Principal getUser(String username) {
        try {
            return this.getUserManager().getUser(username);
        }
        catch (EntityException e) {
            return null;
        }
    }

    protected Authentication createAuthentication(ServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken("anonymous", (Object)"anonymousUser", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ANONYMOUS")});
        auth.setDetails(new AuthenticationDetailsSourceImpl().buildDetails((HttpServletRequest)request));
        return auth;
    }

    @Override
    protected void logoutUser(HttpServletRequest request) {
        SecurityContextHolder.getContext().setAuthentication(this.createAuthentication((ServletRequest)request));
    }

    private UserManager getUserManager() {
        return (UserManager)ContainerManager.getComponent((String)"userManager");
    }
}

