/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.jive;

import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SecurityServerClientFactory;
import com.jivesoftware.base.AuthToken;
import com.jivesoftware.base.IntrospectiveUser;
import com.jivesoftware.base.JiveGlobals;
import com.jivesoftware.base.Permissions;
import com.jivesoftware.base.UserManagerFactory;
import com.jivesoftware.base.UserNotFoundException;
import com.jivesoftware.base.database.ConnectionManager;
import com.jivesoftware.base.database.sequence.SequenceManager;
import com.jivesoftware.util.CacheSizes;
import com.jivesoftware.util.Cacheable;
import com.jivesoftware.util.ExtendedPropertyUtils;
import com.jivesoftware.util.StringUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Logger;

public class CrowdUser
implements IntrospectiveUser,
Cacheable {
    private static final Logger LOGGER = Logger.getLogger(CrowdUser.class);
    private static final String LOAD_PROPERTIES = "SELECT name, propValue FROM jiveUserProp WHERE userID=?";
    private static final String DELETE_PROPERTY = "DELETE FROM jiveUserProp WHERE userID=? AND name=?";
    private static final String UPDATE_PROPERTY = "UPDATE jiveUserProp SET propValue=? WHERE name=? AND userID=?";
    private static final String INSERT_PROPERTY = "INSERT INTO jiveUserProp(userID,name,propValue) VALUES(?,?,?)";
    private static final String INSERT_USER = "INSERT INTO jiveUser(userID,username,passwordHash,name,nameVisible,email,emailVisible,creationDate,modificationDate) VALUES(?,?,'-','-',?,'-',?,?,?)";
    private static final String LOAD_USER_BY_USERNAME = "SELECT userID,username,nameVisible,emailVisible,creationDate,modificationDate FROM jiveUser WHERE username=?";
    private static final String LOAD_USER_BY_ID = "SELECT userID,username,nameVisible,emailVisible,creationDate,modificationDate FROM jiveUser WHERE userID=?";
    private static final String SAVE_USER = "UPDATE jiveUser SET nameVisible=?,emailVisible=?,creationDate=?,modificationDate=? WHERE userID=?";
    private long id = -2L;
    private String username = null;
    private String name = "";
    private boolean nameVisible = true;
    private String email;
    private boolean emailVisible = false;
    private Date creationDate;
    private Date modificationDate;
    private Map properties = new Hashtable();
    private SOAPPrincipal principal = null;
    private final SecurityServerClient securityServerClient;

    protected CrowdUser(String username) throws UserNotFoundException {
        this(username, SecurityServerClientFactory.getSecurityServerClient());
    }

    protected CrowdUser(String username, SecurityServerClient securityServerClient) throws UserNotFoundException {
        this.securityServerClient = securityServerClient;
        this.id = SequenceManager.nextID((int)3);
        this.username = username;
        long now = System.currentTimeMillis();
        this.creationDate = new Date(now);
        this.modificationDate = new Date(now);
        this.properties = new Hashtable();
        if (JiveGlobals.getJiveProperty((String)"crowd.user.defaultNameVisible") != null) {
            this.nameVisible = JiveGlobals.getJiveBooleanProperty((String)"crowd.user.defaultNameVisible");
        }
        if (JiveGlobals.getJiveProperty((String)"crowd.user.defaultEmailVisible") != null) {
            this.emailVisible = JiveGlobals.getJiveBooleanProperty((String)"crowd.user.defaultEmailVisible");
        }
        if (this.username != null) {
            this.username = IdentifierUtils.toLowerCase(this.username);
        }
        this.insertIntoDb();
        this.loadFromDb();
    }

    protected CrowdUser(long userID, Object fakeParam) throws UserNotFoundException {
        this(userID, fakeParam, SecurityServerClientFactory.getSecurityServerClient());
    }

    protected CrowdUser(long userID, Object fakeParam, SecurityServerClient securityServerClient) throws UserNotFoundException {
        this.securityServerClient = securityServerClient;
        LOGGER.debug((Object)("Attempting to create Crowd given userID: " + userID));
        if (userID < 1L) {
            LOGGER.debug((Object)("Given userID of " + userID + " is invalid."));
            throw new UserNotFoundException(userID);
        }
        this.id = userID;
        if (this.username != null) {
            this.username = IdentifierUtils.toLowerCase(this.username);
        }
        this.loadFromDb();
    }

    protected CrowdUser(String username, Object fakeParam) throws UserNotFoundException {
        this(username, fakeParam, SecurityServerClientFactory.getSecurityServerClient());
    }

    protected CrowdUser(String username, Object fakeParam, SecurityServerClient securityServerClient) throws UserNotFoundException {
        this.securityServerClient = securityServerClient;
        LOGGER.debug((Object)("Attempting to create a new Crowd user based on username: " + username));
        if (username == null) {
            throw new UserNotFoundException();
        }
        this.username = username;
        this.username = IdentifierUtils.toLowerCase(this.username);
        this.loadFromDb();
    }

    private SOAPPrincipal getPrincipal() throws InvalidAuthorizationTokenException, RemoteException, com.atlassian.crowd.exception.UserNotFoundException, InvalidAuthenticationException {
        if (this.principal == null) {
            this.principal = this.securityServerClient.findPrincipalByName(this.username);
        }
        return this.principal;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
    }

    public long getID() {
        return this.id;
    }

    public String getUsername() {
        return StringUtils.escapeHTMLTags((String)this.username);
    }

    public String getName() {
        return StringUtils.escapeHTMLTags((String)this.name);
    }

    public void setName(String name) {
        this.name = name;
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public boolean isNameVisible() {
        return this.nameVisible;
    }

    public void setNameVisible(boolean visible) {
        this.nameVisible = visible;
        this.modificationDate.setTime(System.currentTimeMillis());
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public void setPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public String getPasswordHash() {
        throw new UnsupportedOperationException();
    }

    public void setPasswordHash(String passwordHash) {
        throw new UnsupportedOperationException();
    }

    public String getEmail() {
        return StringUtils.escapeHTMLTags((String)this.email);
    }

    public void setEmail(String email) {
        this.email = email;
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public boolean isEmailVisible() {
        return this.emailVisible;
    }

    public void setEmailVisible(boolean visible) {
        this.emailVisible = visible;
        this.modificationDate.setTime(System.currentTimeMillis());
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date modificationDate) {
        this.modificationDate = modificationDate;
        this.saveToDb();
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public String getProperty(String name) {
        if (name == null) {
            return null;
        }
        String value = (String)this.properties.get(name);
        if (value == null) {
            return null;
        }
        return StringUtils.escapeHTMLTags((String)value);
    }

    public void setProperty(String name, String value) {
        value = ExtendedPropertyUtils.validateExtendedProperty((String)name, (String)value);
        if (this.properties.containsKey(name)) {
            if (!value.equals(this.properties.get(name))) {
                this.properties.put(name, value);
                this.updatePropertyInDb(name, value);
            }
        } else {
            this.properties.put(name, value);
            this.insertPropertyIntoDb(name, value);
        }
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    public void deleteProperty(String name) {
        if (this.properties.containsKey(name)) {
            this.properties.remove(name);
            this.deletePropertyFromDb(name);
            UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
        }
    }

    public Iterator getPropertyNames() {
        return this.properties.keySet().iterator();
    }

    public Permissions getPermissions(AuthToken authToken) {
        if (authToken.getUserID() == this.id) {
            return new Permissions(0x200000000000000L);
        }
        return new Permissions(0L);
    }

    public boolean isAuthorized(long type) {
        return true;
    }

    public int getCachedSize() {
        int size = 0;
        size += CacheSizes.sizeOfObject();
        size += CacheSizes.sizeOfLong();
        size += CacheSizes.sizeOfString((String)this.username);
        size += CacheSizes.sizeOfString((String)this.name);
        size += CacheSizes.sizeOfString((String)this.email);
        size += CacheSizes.sizeOfBoolean();
        size += CacheSizes.sizeOfBoolean();
        size += CacheSizes.sizeOfMap((Map)this.properties);
        size += CacheSizes.sizeOfDate();
        size += CacheSizes.sizeOfDate();
        return size += CacheSizes.sizeOfInt();
    }

    public String toString() {
        return this.username;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof CrowdUser) {
            return this.id == ((CrowdUser)object).getID();
        }
        return false;
    }

    public boolean isSetPasswordSupported() {
        return false;
    }

    public boolean isGetPasswordHashSupported() {
        return false;
    }

    public boolean isSetPasswordHashSupported() {
        return false;
    }

    public boolean isSetNameSupported() {
        return false;
    }

    public boolean isSetEmailSupported() {
        return false;
    }

    public boolean isSetNameVisibleSupported() {
        return true;
    }

    public boolean isSetEmailVisibleSupported() {
        return true;
    }

    public boolean isPropertyEditSupported() {
        return true;
    }

    public boolean isReadOnly() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertPropertyIntoDb(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(INSERT_PROPERTY);
            pstmt.setLong(1, this.id);
            pstmt.setString(2, name);
            pstmt.setString(3, value);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            LOGGER.error((Object)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePropertyInDb(String name, String value) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(UPDATE_PROPERTY);
            pstmt.setString(1, value);
            pstmt.setString(2, name);
            pstmt.setLong(3, this.id);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            LOGGER.error((Object)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void deletePropertyFromDb(String name) {
        Connection con = null;
        PreparedStatement pstmt = null;
        boolean abortTransaction = false;
        try {
            con = ConnectionManager.getTransactionConnection();
            pstmt = con.prepareStatement(DELETE_PROPERTY);
            pstmt.setLong(1, this.id);
            pstmt.setString(2, name);
            pstmt.execute();
        }
        catch (SQLException sqle) {
            LOGGER.error((Object)sqle);
            abortTransaction = true;
        }
        finally {
            ConnectionManager.closeTransactionConnection((PreparedStatement)pstmt, (Connection)con, (boolean)abortTransaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertIntoDb() {
        PreparedStatement pstmt;
        Connection con;
        block5: {
            LOGGER.debug((Object)("Inserting user: " + this.username + " with ID " + this.id));
            con = null;
            pstmt = null;
            try {
                con = ConnectionManager.getConnection();
                pstmt = con.prepareStatement(INSERT_USER);
                pstmt.setLong(1, this.id);
                pstmt.setString(2, this.username);
                pstmt.setInt(3, this.nameVisible ? 1 : 0);
                pstmt.setInt(4, this.emailVisible ? 1 : 0);
                pstmt.setLong(5, this.creationDate.getTime());
                pstmt.setLong(6, this.modificationDate.getTime());
                pstmt.executeUpdate();
                if (this.properties.size() <= 0) break block5;
                pstmt.close();
                pstmt = con.prepareStatement(INSERT_PROPERTY);
                for (String name : this.properties.keySet()) {
                    String value = (String)this.properties.get(name);
                    pstmt.setLong(1, this.id);
                    pstmt.setString(2, name);
                    pstmt.setString(3, value);
                    pstmt.executeUpdate();
                }
            }
            catch (SQLException sqle) {
                try {
                    LOGGER.debug((Object)("Error creating user: " + this.username + " with ID " + this.id));
                    LOGGER.error((Object)sqle);
                }
                catch (Throwable throwable) {
                    ConnectionManager.closeConnection(pstmt, (Connection)con);
                    throw throwable;
                }
                ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
            }
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadFromDb() throws UserNotFoundException {
        LOGGER.debug((Object)"Loading user from Jive DB...");
        Connection con = null;
        PreparedStatement pstmt = null;
        con = ConnectionManager.getConnection();
        if (this.username != null) {
            LOGGER.debug((Object)("Running query: SELECT userID,username,nameVisible,emailVisible,creationDate,modificationDate FROM jiveUser WHERE username=?, username: " + this.username));
            pstmt = con.prepareStatement(LOAD_USER_BY_USERNAME);
            pstmt.setString(1, this.username);
        } else {
            LOGGER.debug((Object)("Running query: SELECT userID,username,nameVisible,emailVisible,creationDate,modificationDate FROM jiveUser WHERE userID=?, id: " + this.id));
            pstmt = con.prepareStatement(LOAD_USER_BY_ID);
            pstmt.setLong(1, this.id);
        }
        ResultSet rs = pstmt.executeQuery();
        if (!rs.next()) {
            if (this.username != null) {
                LOGGER.debug((Object)("Failed to load user " + this.username + " from Jive DB"));
                throw new UserNotFoundException("Failed to read user " + this.username + " from database.");
            }
            LOGGER.debug((Object)("Failed to load user " + this.id + " from Jive DB"));
            throw new UserNotFoundException("Failed to read user with ID " + this.id + " from database.");
        }
        LOGGER.debug((Object)("Found ID " + this.id + "with username " + this.username));
        this.id = rs.getLong(1);
        this.username = rs.getString(2);
        this.nameVisible = rs.getInt(3) == 1;
        this.emailVisible = rs.getInt(4) == 1;
        this.creationDate = new Date(rs.getLong(5));
        this.modificationDate = new Date(rs.getLong(6));
        rs.close();
        pstmt.close();
        this.properties = new Hashtable();
        pstmt = con.prepareStatement(LOAD_PROPERTIES);
        pstmt.setLong(1, this.id);
        rs = pstmt.executeQuery();
        while (rs.next()) {
            this.properties.put(rs.getString(1), rs.getString(2));
        }
        rs.close();
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        LOGGER.debug((Object)"Looking for user record found in the Jive DB in Crowd.");
        try {
            try {
                this.getPrincipal();
            }
            catch (Exception e) {
                this.name = this.username;
                LOGGER.debug((Object)("The user " + this.username + " was found in the database, but not in Crowd."));
                return;
            }
            LOGGER.debug((Object)"Loading email and name from Crowd Server...");
            if (this.email == null || this.email.equals("")) {
                this.email = this.getAttribute("mail");
            }
            if (this.name == null || this.name.equals("")) {
                this.name = this.getAttribute("displayName");
            }
            LOGGER.debug((Object)("Email: " + this.email));
            LOGGER.debug((Object)("Name: " + this.name));
        }
        catch (Exception e) {
            LOGGER.debug((Object)"Problem when loading user from Crowd", (Throwable)e);
            throw new UserNotFoundException((Throwable)e);
        }
        catch (SQLException sqle) {
            try {
                LOGGER.debug((Object)("Failed to load user from DB, SQL exception: " + sqle));
                throw new UserNotFoundException("Failed to read user " + this.id + " from database.", (Throwable)sqle);
                catch (NumberFormatException nfe) {
                    LOGGER.error((Object)"WARNING: There was an error parsing the dates returned from the database. Ensure that they're being stored correctly.");
                    throw new UserNotFoundException("User with id " + this.id + " could not be loaded from the database.");
                }
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
        }
        UserManagerFactory.userCache.put((Object)new Long(this.id), (Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveToDb() {
        LOGGER.debug((Object)("Saving user: " + this.username));
        Connection con = null;
        PreparedStatement pstmt = null;
        try {
            con = ConnectionManager.getConnection();
            pstmt = con.prepareStatement(SAVE_USER);
            pstmt.setInt(1, this.nameVisible ? 1 : 0);
            pstmt.setInt(2, this.emailVisible ? 1 : 0);
            pstmt.setLong(3, this.creationDate.getTime());
            pstmt.setLong(4, this.modificationDate.getTime());
            pstmt.setLong(5, this.id);
            pstmt.executeUpdate();
        }
        catch (SQLException sqle) {
            try {
                LOGGER.error((Object)sqle);
            }
            catch (Throwable throwable) {
                ConnectionManager.closeConnection(pstmt, (Connection)con);
                throw throwable;
            }
            ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
        }
        ConnectionManager.closeConnection((PreparedStatement)pstmt, (Connection)con);
    }

    private String[] encodeProps() {
        String[] props = new String[this.properties.size()];
        String[] propNames = new String[props.length];
        int i = 0;
        Iterator iter = this.getPropertyNames();
        while (iter.hasNext()) {
            propNames[i] = (String)iter.next();
            ++i;
        }
        for (int j = 0; j < props.length; ++j) {
            String propValue = (String)this.properties.get(propNames[j]);
            props[j] = propNames[j] + "=" + propValue;
        }
        return props;
    }

    private boolean isFullModeUpdateEnabled() {
        return JiveGlobals.getJiveBooleanProperty((String)"ldap.fullMode.updateDirectory.enabled", (boolean)false);
    }

    private String getAttribute(String name) throws InvalidAuthorizationTokenException, RemoteException, com.atlassian.crowd.exception.UserNotFoundException, InvalidAuthenticationException {
        this.getPrincipal();
        SOAPAttribute[] attributes = this.principal.getAttributes();
        SOAPAttribute matchedAttrib = null;
        for (int i = 0; i < attributes.length; ++i) {
            if (!attributes[i].getName().equals(name)) continue;
            matchedAttrib = attributes[i];
            break;
        }
        if (matchedAttrib != null && matchedAttrib.getValues().length > 0) {
            return matchedAttrib.getValues()[0];
        }
        return null;
    }
}

