/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http.util;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.integration.http.util.CrowdHttpTokenHelper;
import com.atlassian.crowd.integration.http.util.CrowdHttpValidationFactorExtractor;
import com.atlassian.crowd.model.authentication.CookieConfiguration;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.client.ClientProperties;
import java.util.Date;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.apache.log4j.Logger;

public class CrowdHttpTokenHelperImpl
implements CrowdHttpTokenHelper {
    private static final Logger LOGGER = Logger.getLogger(CrowdHttpTokenHelperImpl.class);
    private final CrowdHttpValidationFactorExtractor validationFactorExtractor;

    private CrowdHttpTokenHelperImpl(CrowdHttpValidationFactorExtractor validationFactorExtractor) {
        this.validationFactorExtractor = validationFactorExtractor;
    }

    public String getCrowdToken(HttpServletRequest request, String tokenName) {
        String token;
        boolean debugEnabled;
        Validate.notNull((Object)request);
        Validate.notNull((Object)tokenName);
        boolean bl = debugEnabled = LOGGER != null && LOGGER.isDebugEnabled();
        if (debugEnabled) {
            LOGGER.debug((Object)"Checking for a SSO token that will need to be verified by Crowd.");
        }
        if ((token = (String)request.getAttribute(tokenName)) == null) {
            Cookie[] cookies;
            if (debugEnabled) {
                LOGGER.debug((Object)"No request attribute token could be found, now checking the browser submitted cookies.");
            }
            if ((cookies = request.getCookies()) != null && cookies.length > 0) {
                for (Cookie cookie : cookies) {
                    if (debugEnabled) {
                        LOGGER.debug((Object)("Cookie name/value: " + cookie.getName() + " / " + cookie.getValue()));
                    }
                    if (!tokenName.equals(cookie.getName()) || cookie.getValue() == null) continue;
                    if (debugEnabled) {
                        LOGGER.debug((Object)("Accepting the SSO cookie value: " + cookie.getValue()));
                    }
                    token = cookie.getValue();
                    break;
                }
            }
        }
        if (debugEnabled) {
            if (token == null) {
                LOGGER.debug((Object)"Unable to find a valid Crowd token.");
            } else {
                LOGGER.debug((Object)("Existing token value yet to be verified by Crowd: " + token));
            }
        }
        return token;
    }

    public void removeCrowdToken(HttpServletRequest request, HttpServletResponse response, ClientProperties clientProperties, CookieConfiguration cookieConfig) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)clientProperties);
        if (response != null) {
            Validate.notNull((Object)cookieConfig);
        }
        HttpSession session = request.getSession();
        session.removeAttribute(clientProperties.getSessionTokenKey());
        request.removeAttribute(clientProperties.getCookieTokenKey());
        if (response != null) {
            Cookie tokenCookie = this.buildCookie(null, clientProperties.getCookieTokenKey(), cookieConfig);
            tokenCookie.setMaxAge(0);
            response.addCookie(tokenCookie);
        }
    }

    public void setCrowdToken(HttpServletRequest request, HttpServletResponse response, String token, ClientProperties clientProperties, CookieConfiguration cookieConfig) {
        Validate.notNull((Object)request);
        Validate.notNull((Object)token);
        Validate.notNull((Object)clientProperties);
        if (response != null) {
            Validate.notNull((Object)cookieConfig);
        }
        HttpSession session = request.getSession();
        session.setAttribute(clientProperties.getSessionLastValidation(), (Object)new Date());
        request.setAttribute(clientProperties.getCookieTokenKey(), (Object)token);
        if (response != null && request.getAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED") == null) {
            Cookie tokenCookie = this.buildCookie(token, clientProperties.getCookieTokenKey(), cookieConfig);
            response.addCookie(tokenCookie);
            request.setAttribute("com.atlassian.crowd.integration.http.HttpAuthenticator.REQUEST_SSO_COOKIE_COMMITTED", (Object)Boolean.TRUE);
        }
    }

    public UserAuthenticationContext getUserAuthenticationContext(HttpServletRequest request, String username, String password, ClientProperties clientProperties) {
        PasswordCredential credential = new PasswordCredential(password);
        UserAuthenticationContext userAuthenticationContext = new UserAuthenticationContext();
        userAuthenticationContext.setApplication(clientProperties.getApplicationName());
        userAuthenticationContext.setCredential(credential);
        userAuthenticationContext.setName(username);
        List<ValidationFactor> validationFactors = this.validationFactorExtractor.getValidationFactors(request);
        userAuthenticationContext.setValidationFactors(validationFactors.toArray(new ValidationFactor[0]));
        return userAuthenticationContext;
    }

    public CrowdHttpValidationFactorExtractor getValidationFactorExtractor() {
        return this.validationFactorExtractor;
    }

    private Cookie buildCookie(String token, String tokenCookieKey, CookieConfiguration cookieConfig) {
        String domain = cookieConfig.getDomain();
        boolean isSecure = cookieConfig.isSecure();
        Cookie tokenCookie = new Cookie(tokenCookieKey, token);
        tokenCookie.setPath("/");
        if (domain != null && StringUtils.isNotBlank((String)domain) && !"localhost".equals(domain)) {
            tokenCookie.setDomain(domain);
        }
        tokenCookie.setSecure(isSecure);
        return tokenCookie;
    }

    public static CrowdHttpTokenHelper getInstance(CrowdHttpValidationFactorExtractor validationFactorExtractor) {
        return new CrowdHttpTokenHelperImpl(validationFactorExtractor);
    }
}

