/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.atlassianuser.CrowdUser;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.service.UserManager;
import com.atlassian.crowd.service.cache.CachingManagerFactory;
import com.atlassian.crowd.util.Assert;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CrowdUserManager
implements com.atlassian.user.UserManager {
    private final RepositoryIdentifier repositoryIdentifier;
    private final UserManager userManager;

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, CachingManagerFactory.getUserManagerInstance());
    }

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier, UserManager userManager) {
        this.userManager = userManager;
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public Pager getUsers() throws EntityException {
        try {
            List userNames = this.userManager.getAllUserNames();
            return new DefaultPager((Collection)this.convertStringsToUsers(userNames));
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    protected List convertStringsToUsers(List userNames) {
        if (userNames == null) {
            return new ArrayList(0);
        }
        ArrayList<CrowdUser> users = new ArrayList<CrowdUser>(userNames.size());
        for (String name : userNames) {
            users.add(new CrowdUser(name, this.userManager));
        }
        return users;
    }

    public Pager getUserNames() throws EntityException {
        try {
            return new DefaultPager((Collection)this.userManager.getAllUserNames());
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public User getUser(String name) throws EntityException {
        try {
            SOAPPrincipal user = this.userManager.getUser(name);
            if (user == null) {
                return null;
            }
            return new CrowdUser(user, this.userManager);
        }
        catch (UserNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public User createUser(String name) throws EntityException {
        Assert.notNull(name);
        try {
            SOAPPrincipal principal = new SOAPPrincipal();
            principal.setActive(true);
            principal.setName(name);
            this.userManager.addUser(principal, null);
            return new CrowdUser(principal, this.userManager);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void alterPassword(User user, String password) throws EntityException {
        Assert.notNull(user);
        try {
            this.userManager.updatePassword(user.getName(), new PasswordCredential(password));
        }
        catch (InvalidCredentialException e) {
            throw new InvalidPasswordException(e.getMessage(), (Throwable)e);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public void saveUser(User user) throws EntityException {
        Assert.notNull(user);
        SOAPPrincipal principal = this.convertUserToSOAPPrincipal(user);
        try {
            this.userManager.updateUser(principal);
        }
        catch (ApplicationPermissionException e) {
            throw new UnsupportedOperationException(e);
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    protected SOAPPrincipal convertUserToSOAPPrincipal(User user) {
        Assert.notNull(user);
        Assert.notNull(user.getName());
        SOAPPrincipal principal = new SOAPPrincipal();
        principal.setName(user.getName());
        ArrayList attributes = new ArrayList(2);
        this.buildAttribute("mail", user.getEmail(), attributes);
        this.buildAttribute("displayName", user.getFullName(), attributes);
        this.buildAttribute("givenName", " ", attributes);
        this.buildAttribute("sn", " ", attributes);
        principal.setAttributes(attributes.toArray(new SOAPAttribute[attributes.size()]));
        return principal;
    }

    protected void buildAttribute(String key, String value, List attributes) {
        if (value != null) {
            SOAPAttribute attribute = new SOAPAttribute();
            attribute.setName(key);
            attribute.setValues(new String[1]);
            attribute.getValues()[0] = value;
            attributes.add(attribute);
        }
    }

    public void removeUser(User user) throws EntityException {
        Assert.notNull(user);
        try {
            this.userManager.removeUser(user.getName());
        }
        catch (Exception e) {
            throw new EntityException((Throwable)e);
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }
}

