/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.embedded.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionPoolPropertyUtil {
    public static final String POOL_INITIAL_SIZE = "com.sun.jndi.ldap.connect.pool.initsize";
    public static final String POOL_MAXIMUM_SIZE = "com.sun.jndi.ldap.connect.pool.maxsize";
    public static final String POOL_PREFERRED_SIZE = "com.sun.jndi.ldap.connect.pool.prefsize";
    public static final String POOL_PROTOCOL = "com.sun.jndi.ldap.connect.pool.protocol";
    public static final String POOL_TIMEOUT = "com.sun.jndi.ldap.connect.pool.timeout";
    public static final String POOL_AUTHENTICATION = "com.sun.jndi.ldap.connect.pool.authentication";
    public static final String DEFAULT_INITIAL_POOL_SIZE = "1";
    public static final String DEFAULT_MAXIMUM_POOL_SIZE = "0";
    public static final String DEFAULT_PREFERRED_POOL_SIZE = "10";
    public static final String DEFAULT_POOL_TIMEOUT_MS = "30000";
    public static final String DEFAULT_POOL_PROTOCOL = "plain ssl";
    public static final String DEFAULT_POOL_AUTHENTICATION = "simple";
    public static final Set<String> VALID_PROTOCOL_TYPES = ImmutableSet.of((Object)"plain", (Object)"ssl");
    public static final Set<String> VALID_AUTHENTICATION_TYPES = ImmutableSet.of((Object)"none", (Object)"simple", (Object)"DIGEST-MD5");

    public static boolean isValidProtocol(String userInput) {
        return ConnectionPoolPropertyUtil.isValidEntry(userInput, VALID_PROTOCOL_TYPES);
    }

    public static boolean isValidAuthentication(String userInput) {
        return ConnectionPoolPropertyUtil.isValidEntry(userInput, VALID_AUTHENTICATION_TYPES);
    }

    private static boolean isValidEntry(String userInput, Set<String> validValues) {
        return validValues.containsAll((Collection<?>)ImmutableList.of((Object[])userInput.split(" ")));
    }
}

