/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.soap.server;

import com.atlassian.crowd.integration.authentication.ApplicationAuthenticationContext;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.authentication.UserAuthenticationContext;
import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.BulkAddFailedException;
import com.atlassian.crowd.integration.exception.ExpiredCredentialException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidGroupException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import java.rmi.RemoteException;

public interface SecurityServer {
    public String createPrincipalToken(AuthenticatedToken var1, String var2, ValidationFactor[] var3) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, ApplicationAccessDeniedException;

    public String authenticatePrincipalSimple(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public AuthenticatedToken authenticateApplication(ApplicationAuthenticationContext var1) throws RemoteException, InvalidAuthenticationException, InvalidAuthorizationTokenException;

    public String authenticatePrincipal(AuthenticatedToken var1, UserAuthenticationContext var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public boolean isValidPrincipalToken(AuthenticatedToken var1, String var2, ValidationFactor[] var3) throws RemoteException, InvalidAuthorizationTokenException, ApplicationAccessDeniedException;

    public void invalidatePrincipalToken(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup[] searchGroups(AuthenticatedToken var1, SearchRestriction[] var2) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPPrincipal[] searchPrincipals(AuthenticatedToken var1, SearchRestriction[] var2) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPRole[] searchRoles(AuthenticatedToken var1, SearchRestriction[] var2) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPGroup addGroup(AuthenticatedToken var1, SOAPGroup var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidGroupException, ApplicationPermissionException;

    public void updateGroup(AuthenticatedToken var1, String var2, String var3, boolean var4) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, ObjectNotFoundException;

    public SOAPGroup findGroupByName(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPGroup findGroupWithAttributesByName(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPRole addRole(AuthenticatedToken var1, SOAPRole var2) throws RemoteException, InvalidAuthorizationTokenException, InvalidRoleException, ApplicationPermissionException;

    public SOAPRole findRoleByName(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal findPrincipalByToken(AuthenticatedToken var1, String var2) throws InvalidAuthorizationTokenException, RemoteException, InvalidTokenException;

    public void updatePrincipalAttribute(AuthenticatedToken var1, String var2, SOAPAttribute var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void updateGroupAttribute(AuthenticatedToken var1, String var2, SOAPAttribute var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public SOAPPrincipal findPrincipalByName(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal findPrincipalWithAttributesByName(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public SOAPPrincipal addPrincipal(AuthenticatedToken var1, SOAPPrincipal var2, PasswordCredential var3) throws InvalidAuthorizationTokenException, RemoteException, InvalidCredentialException, InvalidUserException, ApplicationPermissionException;

    public void addAllPrincipals(AuthenticatedToken var1, SOAPPrincipalWithCredential[] var2) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException;

    public void addPrincipalToGroup(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void updatePrincipalCredential(AuthenticatedToken var1, String var2, PasswordCredential var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, InvalidCredentialException, ApplicationPermissionException;

    public void resetPrincipalCredential(AuthenticatedToken var1, String var2) throws RemoteException, InvalidEmailAddressException, InvalidAuthorizationTokenException, InvalidCredentialException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeGroup(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeRole(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipal(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addPrincipalToRole(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public boolean isGroupMember(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isRoleMember(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException;

    public void removePrincipalFromGroup(AuthenticatedToken var1, String var2, String var3) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void removePrincipalFromRole(AuthenticatedToken var1, String var2, String var3) throws InvalidAuthorizationTokenException, RemoteException, ObjectNotFoundException, ApplicationPermissionException;

    public void addAttributeToPrincipal(AuthenticatedToken var1, String var2, SOAPAttribute var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void addAttributeToGroup(AuthenticatedToken var1, String var2, SOAPAttribute var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeAttributeFromPrincipal(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public void removeAttributeFromGroup(AuthenticatedToken var1, String var2, String var3) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException;

    public long getCacheTime(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public boolean isCacheEnabled(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String getDomain(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllPrincipalNames(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllGroupNames(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPNestableGroup[] findAllGroupRelationships(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findAllRoleNames(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public String[] findGroupMemberships(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public String[] findRoleMemberships(AuthenticatedToken var1, String var2) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException;

    public String[] getGrantedAuthorities(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;

    public SOAPCookieInfo getCookieInfo(AuthenticatedToken var1) throws RemoteException, InvalidAuthorizationTokenException;
}

