/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.BasicCache;
import com.atlassian.crowd.integration.service.cache.CacheAwareAuthenticationManager;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManager;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManagerImpl;
import com.atlassian.crowd.integration.service.cache.CacheImpl;
import com.atlassian.crowd.integration.service.cache.CachingGroupManager;
import com.atlassian.crowd.integration.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.CachingUserManager;
import com.atlassian.crowd.integration.service.cache.SimpleAuthenticationManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import java.net.URL;

public class CachingManagerFactory {
    protected static CachingGroupMembershipManager getGroupMembershipManager() {
        return new CachingGroupMembershipManager(CachingManagerFactory.getSSC(), CachingManagerFactory.getUserManager(), CachingManagerFactory.getGroupManager(), CachingManagerFactory.getCache());
    }

    protected static CachingUserManager getUserManager() {
        return new CachingUserManager(CachingManagerFactory.getSSC(), CachingManagerFactory.getCache());
    }

    protected static CachingGroupManager getGroupManager() {
        return new CachingGroupManager(CachingManagerFactory.getSSC(), CachingManagerFactory.getCache());
    }

    protected static CacheAwareAuthenticationManager getCacheAwareAuthenticationManager() {
        return new CacheAwareAuthenticationManager(CachingManagerFactory.getSSC(), CachingManagerFactory.getUserManager());
    }

    private static SecurityServerClient getSSC() {
        return SecurityServerClientFactory.getSecurityServerClient();
    }

    protected static SimpleAuthenticationManager getSimpleAuthenticationManager() {
        return new SimpleAuthenticationManager(CachingManagerFactory.getSSC());
    }

    public static AuthenticationManager getCacheAwareAuthenticationManagerInstance() {
        return CachingManagerHolder.authenticationManager;
    }

    public static AuthenticationManager getSimpleAuthenticationManagerInstance() {
        return SimpleAuthenticationManagerHolder.authenticationManager;
    }

    public static UserManager getUserManagerInstance() {
        return CachingManagerHolder.userManager;
    }

    public static GroupManager getGroupManagerInstance() {
        return CachingManagerHolder.groupManager;
    }

    public static GroupMembershipManager getGroupMembershipManagerInstance() {
        return CachingManagerHolder.groupMembershipManager;
    }

    public static CacheExpiryManager getCacheExpiryManagerInstance() {
        return CacheExpiryManagerHolder.cacheExpiryManager;
    }

    public static BasicCache getCache() {
        return CacheHolder.basicCache;
    }

    private static class CacheExpiryManagerHolder {
        private static final CacheExpiryManager cacheExpiryManager = new CacheExpiryManagerImpl(CachingManagerFactory.getCache());

        private CacheExpiryManagerHolder() {
        }
    }

    private static class CacheHolder {
        private static final URL cacheUrlWithoutSlash = CachingManagerFactory.class.getResource("crowd-ehcache.xml");
        private static final URL cacheUrlWithSlash = CachingManagerFactory.class.getResource("/crowd-ehcache.xml");
        private static final BasicCache basicCache = new CacheImpl(cacheUrlWithSlash != null ? cacheUrlWithSlash : cacheUrlWithoutSlash);

        private CacheHolder() {
        }
    }

    private static class CachingManagerHolder {
        private static final CachingGroupMembershipManager groupMembershipManager = CachingManagerFactory.getGroupMembershipManager();
        private static final CachingGroupManager groupManager = CachingManagerFactory.getGroupManager();
        private static final CachingUserManager userManager = CachingManagerFactory.getUserManager();
        private static final CacheAwareAuthenticationManager authenticationManager = CachingManagerFactory.getCacheAwareAuthenticationManager();

        private CachingManagerHolder() {
        }
    }

    private static class SimpleAuthenticationManagerHolder {
        private static final AuthenticationManager authenticationManager = CachingManagerFactory.getSimpleAuthenticationManager();

        private SimpleAuthenticationManagerHolder() {
        }
    }
}

