/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.exception.ApplicationPermissionException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.BasicCache;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.util.Assert;
import com.atlassian.crowd.integration.util.NestingHelper;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class CachingGroupMembershipManager
implements GroupMembershipManager {
    private final Server server;
    private final GroupManager groupManager;
    private final UserManager userManager;
    private final BasicCache basicCache;

    public CachingGroupMembershipManager(SecurityServerClient securityServerClient, UserManager userManager, GroupManager groupManager, BasicCache basicCache) {
        this.userManager = userManager;
        this.groupManager = groupManager;
        this.basicCache = basicCache;
        this.server = new Server(securityServerClient);
    }

    public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        Boolean isMember = this.basicCache.isMember(userName, groupName);
        if (isMember == null) {
            isMember = this.basicCache.isMemberInGroupCache(userName, groupName);
            if (isMember == null) {
                isMember = this.server.isMember(userName, groupName);
            }
            this.basicCache.setMembership(userName, groupName, isMember);
        }
        return isMember;
    }

    public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.server.addMembership(userName, groupName);
        this.getMemberships(userName);
        this.getMembers(groupName);
        this.basicCache.setMembership(userName, groupName, Boolean.TRUE);
        this.basicCache.addUserToGroup(userName, groupName);
        this.basicCache.addGroupToUser(userName, groupName);
    }

    public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
        Assert.notNull(userName);
        Assert.notNull(groupName);
        this.server.removeMembership(userName, groupName);
        this.basicCache.setMembership(userName, groupName, Boolean.FALSE);
        this.basicCache.removeUserFromGroup(userName, groupName);
        this.basicCache.removeGroupFromUser(userName, groupName);
    }

    public List getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        Assert.notNull(userName);
        List groupNames = this.basicCache.getAllMemberships(userName);
        if (groupNames == null) {
            List directGroups = this.server.getMemberships(userName);
            if (directGroups != null && directGroups.size() > 0) {
                this.primeGroupNameCache();
            }
            groupNames = NestingHelper.getAllGroupsForUser(directGroups, this.basicCache);
            this.basicCache.addOrReplaceAllMemberships(userName, groupNames);
        }
        if (groupNames == null || groupNames.size() == 0) {
            return new ArrayList(1);
        }
        return groupNames;
    }

    public List getMembers(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
        SOAPGroup group;
        Assert.notNull(groupName);
        List users = this.basicCache.getAllMembers(groupName);
        if (users == null && (group = this.basicCache.getGroup(groupName)) == null) {
            group = this.server.getGroup(groupName);
            users = this.basicCache.setMembers(groupName, group.getMembers());
            this.basicCache.addOrReplaceGroup(group);
        }
        if (users == null) {
            users = new ArrayList(1);
        }
        return users;
    }

    public Boolean isUserOrGroup(String name) throws InvalidAuthorizationTokenException, RemoteException {
        Assert.notNull(name);
        Boolean isUserOrGroup = this.basicCache.isUserOrGroup(name);
        if (isUserOrGroup == null) {
            if (this.groupManager.isGroup(name) || this.userManager.isUser(name)) {
                isUserOrGroup = Boolean.TRUE;
                this.basicCache.addIsUserOrGroup(name, Boolean.TRUE);
            } else {
                isUserOrGroup = Boolean.FALSE;
                this.basicCache.addIsUserOrGroup(name, Boolean.FALSE);
            }
        }
        return isUserOrGroup;
    }

    private void primeGroupNameCache() throws RemoteException, InvalidAuthorizationTokenException {
        if (!this.basicCache.containsGroupRelationships()) {
            this.groupManager.getAllGroupNames();
        }
    }

    private static class Server {
        private final SecurityServerClient securityServerClient;

        private Server(SecurityServerClient securityServerClient) {
            this.securityServerClient = securityServerClient;
        }

        public boolean isMember(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException {
            return this.securityServerClient.isGroupMember(groupName, userName);
        }

        public void addMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.securityServerClient.addPrincipalToGroup(userName, groupName);
        }

        public void removeMembership(String userName, String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException, ApplicationPermissionException {
            this.securityServerClient.removePrincipalFromGroup(userName, groupName);
        }

        public List getMemberships(String userName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            String[] groupNames = this.securityServerClient.findGroupMemberships(userName);
            return Arrays.asList(groupNames);
        }

        public SOAPGroup getGroup(String groupName) throws RemoteException, InvalidAuthorizationTokenException, ObjectNotFoundException {
            return this.securityServerClient.findGroupByName(groupName);
        }
    }
}

