/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.service.cache;

import com.atlassian.crowd.integration.service.AuthenticationManager;
import com.atlassian.crowd.integration.service.GroupManager;
import com.atlassian.crowd.integration.service.GroupMembershipManager;
import com.atlassian.crowd.integration.service.UserManager;
import com.atlassian.crowd.integration.service.cache.AuthenticationManagerImpl;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManager;
import com.atlassian.crowd.integration.service.cache.CacheExpiryManagerImpl;
import com.atlassian.crowd.integration.service.cache.CachingGroupManager;
import com.atlassian.crowd.integration.service.cache.CachingGroupMembershipManager;
import com.atlassian.crowd.integration.service.cache.CachingUserManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;

public class CachingManagerFactory {
    protected static CachingGroupMembershipManager getNewGroupMembershipManager() {
        return new CachingGroupMembershipManager(CachingManagerFactory.getSSC());
    }

    protected static CachingUserManager getNewUserManager() {
        return new CachingUserManager(CachingManagerFactory.getSSC());
    }

    protected static CachingGroupManager getNewGroupManager() {
        return new CachingGroupManager(CachingManagerFactory.getSSC());
    }

    protected static SecurityServerClient getSSC() {
        return SecurityServerClientFactory.getSecurityServerClient();
    }

    public static AuthenticationManager getAuthenticationManagerInstance() {
        return AuthenticationManagerHolder.authenticationManager;
    }

    public static UserManager getUserManagerInstance() {
        return CachingManagerHolder.userManager;
    }

    public static GroupManager getGroupManagerInstance() {
        return CachingManagerHolder.groupManager;
    }

    public static GroupMembershipManager getGroupMembershipManagerInstance() {
        return CachingManagerHolder.groupMembershipManager;
    }

    public static CacheExpiryManager getCacheExpiryManagerInstance() {
        return CacheExpiryManagerHolder.cacheExpiryManager;
    }

    private static class CacheExpiryManagerHolder {
        private static final CacheExpiryManager cacheExpiryManager = new CacheExpiryManagerImpl();

        private CacheExpiryManagerHolder() {
        }
    }

    private static class CachingManagerHolder {
        private static final CachingGroupMembershipManager groupMembershipManager = CachingManagerFactory.getNewGroupMembershipManager();
        private static final CachingGroupManager groupManager = CachingManagerFactory.getNewGroupManager();
        private static final CachingUserManager userManager = CachingManagerFactory.getNewUserManager();

        private CachingManagerHolder() {
        }

        static {
            userManager.setCachingGroupMembershipManager(groupMembershipManager);
            groupManager.setCachingGroupMembershipManager(groupMembershipManager);
            groupMembershipManager.setCachingGroupManager(groupManager);
            groupMembershipManager.setCachingUserManager(userManager);
        }
    }

    private static class AuthenticationManagerHolder {
        private static final AuthenticationManager authenticationManager = new AuthenticationManagerImpl(CachingManagerFactory.getSSC());

        private AuthenticationManagerHolder() {
        }
    }
}

