/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser.providers;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.osuser.CrowdBaseProvider;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.module.propertyset.PropertySetManager;
import com.opensymphony.user.provider.ProfileProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Category;

public class ChainedProfileProvider
extends CrowdBaseProvider
implements ProfileProvider {
    private static final Category log = Category.getInstance(ChainedProfileProvider.class);
    public static final String PROPERTY_NAME_KEY = "name";
    protected static final String ssoPropertySetName = "crowd";
    private ProfileProvider nextProvider;

    public ChainedProfileProvider() {
        this(SecurityServerClientFactory.getSecurityServerClient(), HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    public ChainedProfileProvider(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        super(securityServerClient, httpAuthenticator);
    }

    public boolean init(Properties properties) {
        if (!properties.containsKey("chain.classname") || properties.getProperty("chain.classname").length() == 0) {
            log.error((Object)"ChainedUserProvider requires a 'chain.classname' init property to determine next class in chain");
            return false;
        }
        try {
            Class<?> next = Class.forName(properties.getProperty("chain.classname"));
            if (!this.getProviderClass().isAssignableFrom(next)) {
                log.error((Object)("Configured chained class " + next.getName() + " is not of expected type " + this.getProviderClass().getName()));
                return false;
            }
            this.nextProvider = (ProfileProvider)next.newInstance();
            return this.nextProvider.init(this.extractChainedProperties(properties));
        }
        catch (Exception e) {
            log.error((Object)("Unable to instantiate chained access provider class " + properties.getProperty("chain.classname")), (Throwable)e);
            return false;
        }
    }

    private Properties extractChainedProperties(Properties properties) {
        Properties newProps = new Properties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith("chain.") || key.equals("chain.classname") || key.length() <= 6) continue;
            newProps.put(key.substring(6), entry.getValue());
        }
        return newProps;
    }

    public PropertySet getPropertySet(String user) {
        PropertySet chainedProviderPS;
        ArrayList<PropertySet> propertySets = new ArrayList<PropertySet>();
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put(PROPERTY_NAME_KEY, user);
        PropertySet crowdPS = PropertySetManager.getInstance((String)ssoPropertySetName, args);
        if (crowdPS != null) {
            propertySets.add(crowdPS);
        }
        if ((chainedProviderPS = this.nextProvider.getPropertySet(user)) != null) {
            propertySets.add(chainedProviderPS);
        }
        args.clear();
        args.put("PropertySets", propertySets);
        return PropertySetManager.getInstance((String)"aggregate", args);
    }

    protected Class getProviderClass() {
        return ProfileProvider.class;
    }
}

