/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.osuser;

import com.atlassian.crowd.integration.cache.CacheManagerFactory;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.osuser.CrowdBaseProvider;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.opensymphony.user.Entity;
import com.opensymphony.user.provider.AccessProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.ehcache.CacheException;

public class CrowdAccessProvider
extends CrowdBaseProvider
implements AccessProvider {
    public CrowdAccessProvider() {
        this(SecurityServerClientFactory.getSecurityServerClient(), HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    public CrowdAccessProvider(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        super(securityServerClient, httpAuthenticator);
    }

    public CrowdAccessProvider(CacheManagerFactory cacheManagerFactory, SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        super(cacheManagerFactory, securityServerClient, httpAuthenticator);
    }

    public boolean handles(String name) {
        try {
            List groupNames = this.list();
            if (groupNames != null && groupNames.contains(name)) {
                return true;
            }
            if (this.findPrincipalByName(name) != null) {
                return true;
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public List list() {
        return this.findAllGroupNames();
    }

    public boolean load(String string, Entity.Accessor accessor) {
        accessor.setMutable(true);
        return true;
    }

    public boolean addToGroup(String username, String groupname) {
        boolean success = false;
        if (!this.inGroup(username, groupname)) {
            try {
                this.securityServerClient.addPrincipalToGroup(username, groupname);
                if (this.getCacheManager().isCacheEnabled()) {
                    this.getCacheManager().removePrincipalMemberships(username);
                    this.getCacheManager().removeGroupMemberships(groupname);
                }
                success = true;
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return success;
    }

    public boolean inGroup(String username, String groupname) {
        try {
            return this.listGroupsContainingUser(username).contains(groupname);
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public List listGroupsContainingUser(String username) {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getPrincipalMemberships(username);
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        try {
            List<String> groupNames = Arrays.asList(this.securityServerClient.findGroupMemberships(username));
            if (this.getCacheManager().isCacheEnabled()) {
                this.getCacheManager().cachePrincipalMemberships(username, groupNames);
            }
            return groupNames;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
            return new ArrayList(0);
        }
    }

    public List listUsersInGroup(String name) {
        List<Object> members = new ArrayList();
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                members = this.getCacheManager().getGroupMemberships(name);
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        if (members.isEmpty()) {
            try {
                SOAPGroup group = this.securityServerClient.findGroupByName(name);
                members = Arrays.asList(group.getMembers());
                if (this.getCacheManager().isCacheEnabled()) {
                    this.getCacheManager().cacheGroup(group);
                    this.getCacheManager().cacheGroupMemberships(group.getName(), members);
                }
            }
            catch (Exception e) {
                this.logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        return members;
    }

    public boolean removeFromGroup(String username, String groupname) {
        boolean success = false;
        try {
            this.securityServerClient.removePrincipalFromGroup(username, groupname);
            if (this.getCacheManager().isCacheEnabled()) {
                this.getCacheManager().removePrincipalMemberships(username);
                this.getCacheManager().removeGroupMemberships(username);
            }
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean remove(String name) {
        boolean success = false;
        try {
            this.securityServerClient.removeGroup(name);
            if (this.getCacheManager().isCacheEnabled()) {
                this.getCacheManager().removeGroup(name);
                this.getCacheManager().removeGroupMemberships(name);
            }
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }

    public boolean create(String name) {
        boolean success = false;
        SOAPGroup soapGroup = new SOAPGroup();
        soapGroup.setActive(true);
        soapGroup.setName(name);
        try {
            this.securityServerClient.addGroup(soapGroup);
            this.flushCaches();
            success = true;
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return success;
    }
}

