/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.fisheye;

import com.atlassian.crowd.integration.authentication.PrincipalAuthenticationContext;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidAuthenticationException;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.fisheye.FisheyeAuthToken;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.cenqua.fisheye.user.plugin.AbstractFishEyeAuthenticator;
import com.cenqua.fisheye.user.plugin.AuthToken;
import java.rmi.RemoteException;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FisheyeAuthenticator
extends AbstractFishEyeAuthenticator {
    private static final Logger logger = Logger.getLogger(FisheyeAuthenticator.class);
    private final SecurityServerClient securityServerClient;
    private final HttpAuthenticator httpAuthenticator;

    public FisheyeAuthenticator() {
        this(SecurityServerClientFactory.getSecurityServerClient(), HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    public FisheyeAuthenticator(SecurityServerClient securityServerClient, HttpAuthenticator httpAuthenticator) {
        this.securityServerClient = securityServerClient;
        this.httpAuthenticator = httpAuthenticator;
    }

    public void init(Properties properties) throws Exception {
        this.securityServerClient.getClientProperties().updateProperties(properties);
    }

    public void close() {
    }

    public AuthToken checkPassword(String username, String password) {
        try {
            PrincipalAuthenticationContext authenticationContext = this.httpAuthenticator.getPrincipalAuthenticationContext(null, null, username, password);
            String token = this.securityServerClient.authenticatePrincipal(authenticationContext);
            SOAPPrincipal principal = this.securityServerClient.findPrincipalByToken(token);
            return this.generateAuthToken(principal);
        }
        catch (RemoteException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidAuthorizationTokenException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidAuthenticationException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        catch (InactiveAccountException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidTokenException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public AuthToken recreateAuth(String username) {
        try {
            SOAPPrincipal principal = this.securityServerClient.findPrincipalByName(username);
            return this.generateAuthToken(principal);
        }
        catch (RemoteException e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
        }
        catch (InvalidAuthorizationTokenException e) {
            logger.info((Object)e.getMessage(), (Throwable)e);
        }
        catch (ObjectNotFoundException e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public boolean hasPermissionToAccess(AuthToken authToken, String repository, String group) {
        if (group != null) {
            try {
                return this.securityServerClient.isGroupMember(group, authToken.getUsername());
            }
            catch (RemoteException e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
            }
            catch (InvalidAuthorizationTokenException e) {
                logger.info((Object)e.getMessage(), (Throwable)e);
            }
        }
        return true;
    }

    private AuthToken generateAuthToken(SOAPPrincipal principal) {
        return new FisheyeAuthToken(principal);
    }
}

