/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.cache;

import com.atlassian.crowd.integration.cache.CacheManager;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import java.io.Serializable;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import net.sf.ehcache.config.ConfigurationHelper;
import org.apache.log4j.Logger;

public class CacheManagerImpl
implements CacheManager {
    private static final Logger logger = Logger.getLogger(CacheManagerImpl.class);
    private static String CROWD_CACHE = CacheManagerImpl.class.getName();
    private static boolean cacheEnabled = false;
    protected static final String PRINCIPAL_KEY = CROWD_CACHE + ".PRINCIPAL_KEY.";
    protected static final String PRINCIPALMEMBERSHIPS_KEY = CROWD_CACHE + ".PRINCIPALMEMBERSHIPS_KEY.";
    protected static final String GROUPMEMBERSHIPS_KEY = CROWD_CACHE + ".GROUPMEMBERSHIPS_KEY.";
    protected static final String GROUP_KEY = CROWD_CACHE + ".GROUP_KEY.";
    protected static final String PRINCIPALNAMES_KEY = CROWD_CACHE + ".PRINCIPALNAMES_KEY.";
    protected static final String GROUPNAMES_KEY = CROWD_CACHE + ".GROUPNAMES_KEY.";
    protected static Boolean serverCacheCheck = Boolean.FALSE;
    private net.sf.ehcache.CacheManager ehCacheManager;
    private final SecurityServerClient securityServerClient;

    public static CacheManager getInstance() {
        return CacheManagerHolder.cacheManager;
    }

    private CacheManagerImpl() {
        this(SecurityServerClientFactory.getSecurityServerClient());
    }

    private CacheManagerImpl(SecurityServerClient securityServerClient) {
        Configuration configuration;
        this.securityServerClient = securityServerClient;
        this.processCachingRules();
        URL url = this.getClass().getResource("/crowd-ehcache.xml");
        this.ehCacheManager = net.sf.ehcache.CacheManager.create((URL)url);
        if (!this.ehCacheManager.cacheExists(CROWD_CACHE) && (configuration = ConfigurationFactory.parseConfiguration((URL)url)) != null) {
            ConfigurationHelper helper = new ConfigurationHelper(this.ehCacheManager, configuration);
            Set caches = helper.createCaches();
            if (!caches.isEmpty()) {
                for (Cache cache : caches) {
                    if (this.ehCacheManager.cacheExists(cache.getName())) continue;
                    this.ehCacheManager.addCache(cache);
                }
            } else {
                this.ehCacheManager.addCache(CROWD_CACHE);
            }
        }
    }

    protected CacheManagerImpl(Cache cache, SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
        this.ehCacheManager = net.sf.ehcache.CacheManager.create();
        if (!this.ehCacheManager.cacheExists(CROWD_CACHE) && cache != null) {
            this.ehCacheManager.addCache(cache);
        }
    }

    protected void processCachingRules() {
        if (serverCacheCheck.equals(Boolean.FALSE)) {
            try {
                cacheEnabled = this.securityServerClient.isCacheEnabled();
            }
            catch (Exception e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                cacheEnabled = true;
            }
            logger.info((Object)("Caching is enabled: " + cacheEnabled));
            serverCacheCheck = Boolean.TRUE;
        }
    }

    public boolean isCacheEnabled() {
        return cacheEnabled;
    }

    protected Cache getDefaultCache() {
        return this.ehCacheManager.getCache(CROWD_CACHE);
    }

    protected Object getFromCache(String key) throws CacheException {
        Element element = this.getDefaultCache().get((Serializable)((Object)key));
        if (element == null) {
            throw new CacheException("Object not found in cache: " + key);
        }
        return element.getValue();
    }

    protected void putInCache(String key, Object object) {
        Element element = new Element((Serializable)((Object)key), (Serializable)object);
        this.getDefaultCache().put(element);
    }

    public void cachePrincipals(SOAPPrincipal[] principals) {
        this.putInCache(PRINCIPAL_KEY, Arrays.asList(principals));
        for (int memberCtr = 0; memberCtr < principals.length; ++memberCtr) {
            SOAPPrincipal principal = principals[memberCtr];
            try {
                this.getPrincipal(principal.getName());
                continue;
            }
            catch (CacheException e) {
                this.cachePrincipal(principal);
            }
        }
    }

    public SOAPPrincipal getPrincipal(String name) throws CacheException {
        String key = PRINCIPAL_KEY + name;
        return (SOAPPrincipal)this.getFromCache(key);
    }

    public void cacheGroups(SOAPGroup[] groups) {
        this.putInCache(GROUP_KEY, Arrays.asList(groups));
        for (int ctr = 0; ctr < groups.length; ++ctr) {
            this.cacheGroup(groups[ctr]);
        }
    }

    public void cacheGroup(SOAPGroup group) {
        String key = GROUP_KEY + group.getName();
        this.putInCache(key, group);
    }

    public void cacheGroupMemberships(String groupname, List memberships) {
        String key = GROUPMEMBERSHIPS_KEY + groupname;
        this.putInCache(key, memberships);
    }

    public List getGroupMemberships(String groupname) {
        String key = GROUPMEMBERSHIPS_KEY + groupname;
        return (List)this.getFromCache(key);
    }

    public List getGroups() throws CacheException {
        return (List)this.getFromCache(GROUP_KEY);
    }

    public SOAPGroup getGroup(String name) throws CacheException {
        String key = GROUP_KEY + name;
        return (SOAPGroup)this.getFromCache(key);
    }

    public void cachePrincipal(SOAPPrincipal principal) {
        String key = PRINCIPAL_KEY + principal.getName();
        this.putInCache(key, principal);
    }

    public List getPrincipals() throws CacheException {
        return (List)this.getFromCache(PRINCIPAL_KEY);
    }

    public List getPrincipalNames() throws CacheException {
        return (List)this.getFromCache(PRINCIPALNAMES_KEY);
    }

    public void cachePrincipalNames(List principalNames) {
        this.putInCache(PRINCIPALNAMES_KEY, principalNames);
    }

    public void cacheGroupNames(List principalNames) {
        this.putInCache(GROUPNAMES_KEY, principalNames);
    }

    public List getGroupNames() throws CacheException {
        return (List)this.getFromCache(GROUPNAMES_KEY);
    }

    public List getPrincipalMemberships(String username) throws CacheException {
        String key = PRINCIPALMEMBERSHIPS_KEY + username;
        return (List)this.getFromCache(key);
    }

    public void cachePrincipalMemberships(String username, List memberships) {
        String key = PRINCIPALMEMBERSHIPS_KEY + username;
        this.putInCache(key, memberships);
    }

    public void flushCaches() {
        try {
            this.getDefaultCache().removeAll();
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void removeGroup(String groupName) {
        String key = GROUP_KEY + groupName;
        this.getDefaultCache().remove((Serializable)((Object)key));
    }

    public void removePrincipal(String username) {
        String key = PRINCIPAL_KEY + username;
        this.getDefaultCache().remove((Serializable)((Object)key));
    }

    public void removePrincipalMemberships(String username) {
        String key = PRINCIPALMEMBERSHIPS_KEY + username;
        this.getDefaultCache().remove((Serializable)((Object)key));
    }

    public void removeGroupMemberships(String groupname) {
        String key = GROUPMEMBERSHIPS_KEY + groupname;
        this.getDefaultCache().remove((Serializable)((Object)key));
    }

    private static class CacheManagerHolder {
        private static final CacheManager cacheManager = new CacheManagerImpl();

        private CacheManagerHolder() {
        }
    }
}

