/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.atlassianuser.AbstractManager;
import com.atlassian.crowd.integration.atlassianuser.CrowdUser;
import com.atlassian.crowd.integration.authentication.PasswordCredential;
import com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.user.Entity;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.atlassian.user.repository.RepositoryIdentifier;
import com.atlassian.user.search.page.DefaultPager;
import com.atlassian.user.search.page.Pager;
import com.atlassian.user.security.authentication.InvalidPasswordException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Logger;

public class CrowdUserManager
extends AbstractManager
implements UserManager {
    private static final Logger logger = Logger.getLogger(CrowdUserManager.class);
    private final RepositoryIdentifier repositoryIdentifier;

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier) {
        this(repositoryIdentifier, SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdUserManager(RepositoryIdentifier repositoryIdentifier, SecurityServerClient securityServerClient) {
        super(securityServerClient);
        this.repositoryIdentifier = repositoryIdentifier;
    }

    public Pager getUsers() throws EntityException {
        try {
            List crowdPrincipalNames = this.findAllPrincipalNames();
            ArrayList<CrowdUser> users = new ArrayList<CrowdUser>(crowdPrincipalNames.size());
            for (String name : crowdPrincipalNames) {
                users.add(new CrowdUser(name));
            }
            return new DefaultPager(users);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public Pager getUserNames() throws EntityException {
        try {
            List principalNames = this.findAllPrincipalNames();
            return new DefaultPager((Collection)principalNames);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public User getUser(String name) throws EntityException {
        try {
            if (this.getCacheManager().isCacheEnabled()) {
                try {
                    return new CrowdUser(this.getCacheManager().getPrincipal(name));
                }
                catch (CacheException e) {
                    // empty catch block
                }
            }
            SOAPPrincipal principal = this.securityServerClient.findPrincipalByName(name);
            if (this.getCacheManager().isCacheEnabled()) {
                this.getCacheManager().cachePrincipal(principal);
            }
            return new CrowdUser(principal);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public User createUser(String name) throws EntityException {
        try {
            SOAPPrincipal principal = new SOAPPrincipal();
            principal.setActive(true);
            principal.setName(name);
            PasswordCredential credentials = new PasswordCredential();
            credentials.setCredential("");
            principal = this.securityServerClient.addPrincipal(principal, credentials);
            this.getCacheManager().flushCaches();
            return new CrowdUser(principal);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public void alterPassword(User user, String password) throws EntityException {
        try {
            PasswordCredential passwordCredential = new PasswordCredential();
            passwordCredential.setCredential(password);
            this.securityServerClient.updatePrincipalCredential(user.getName(), passwordCredential);
        }
        catch (InvalidCredentialException e) {
            throw new InvalidPasswordException(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveUser(User user) throws EntityException {
        try {
            try {
                this.securityServerClient.updatePrincipalAttribute(user.getName(), this.buildAttribute("mail", user.getEmail()));
            }
            catch (ObjectNotFoundException e) {
            }
            catch (Exception e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                throw new EntityException(e.getMessage(), (Throwable)e);
            }
            try {
                this.securityServerClient.updatePrincipalAttribute(user.getName(), this.buildAttribute("displayName", user.getFullName()));
            }
            catch (ObjectNotFoundException e) {
            }
            catch (Exception e) {
                logger.fatal((Object)e.getMessage(), (Throwable)e);
                throw new EntityException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            try {
                this.getCacheManager().cachePrincipal(this.securityServerClient.findPrincipalByName(user.getName()));
            }
            catch (ObjectNotFoundException e) {
                this.getCacheManager().flushCaches();
            }
            catch (Exception e) {
                this.getCacheManager().flushCaches();
                throw new EntityException((Throwable)e);
            }
        }
    }

    protected SOAPAttribute buildAttribute(String key, String value) {
        SOAPAttribute attribute = new SOAPAttribute();
        attribute.setName(key);
        attribute.setValues(new String[1]);
        attribute.getValues()[0] = value;
        return attribute;
    }

    public void removeUser(User user) throws EntityException {
        try {
            this.securityServerClient.removePrincipal(user.getName());
            this.getCacheManager().flushCaches();
        }
        catch (Exception e) {
            logger.fatal((Object)e.getMessage(), (Throwable)e);
            throw new EntityException(e.getMessage(), (Throwable)e);
        }
    }

    public boolean isReadOnly(User user) throws EntityException {
        return false;
    }

    public RepositoryIdentifier getIdentifier() {
        return this.repositoryIdentifier;
    }

    public RepositoryIdentifier getRepository(Entity entity) throws EntityException {
        if (this.getUser(entity.getName()) != null) {
            return this.repositoryIdentifier;
        }
        return null;
    }

    public boolean isCreative() {
        return true;
    }

    protected List findAllPrincipalNames() throws InvalidAuthorizationTokenException, RemoteException {
        if (this.getCacheManager().isCacheEnabled()) {
            try {
                return this.getCacheManager().getPrincipalNames();
            }
            catch (CacheException e) {
                // empty catch block
            }
        }
        List<String> principalNames = Arrays.asList(this.securityServerClient.findAllPrincipalNames());
        if (this.getCacheManager().isCacheEnabled()) {
            this.getCacheManager().cachePrincipalNames(principalNames);
        }
        return principalNames;
    }
}

