/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.atlassianuser;

import com.atlassian.crowd.integration.cache.CacheManager;
import com.atlassian.crowd.integration.cache.CacheManagerImpl;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.service.soap.client.SecurityServerClientFactory;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.user.impl.DefaultUser;
import net.sf.ehcache.CacheException;
import org.apache.log4j.Logger;

public class CrowdUser
extends DefaultUser {
    private static final Logger logger = Logger.getLogger(CrowdUser.class);
    private final SecurityServerClient securityServerClient;
    private boolean fetchedName;
    private boolean fetchedEmail;
    private SOAPPrincipal principal;

    public CrowdUser() {
        this(SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdUser(SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
    }

    public CrowdUser(String name) {
        this(name, SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdUser(String name, SecurityServerClient securityServerClient) {
        super(name);
        this.securityServerClient = securityServerClient;
    }

    public CrowdUser(SOAPPrincipal principal) {
        this(principal, SecurityServerClientFactory.getSecurityServerClient());
    }

    public CrowdUser(SOAPPrincipal principal, SecurityServerClient securityServerClient) {
        this.securityServerClient = securityServerClient;
        this.principal = principal;
        this.name = principal.getName();
        this.processEmail();
        this.processFullName();
    }

    protected CacheManager getCacheManager() {
        return CacheManagerImpl.getInstance();
    }

    public String getFullName() {
        if (!this.fetchedName) {
            this.processFullName();
        }
        return super.getFullName();
    }

    public String getEmail() {
        if (!this.fetchedEmail) {
            this.processEmail();
        }
        return super.getEmail();
    }

    private void processFullName() {
        if (!this.fetchedName) {
            StringBuffer fullName = new StringBuffer();
            String[] displayName = this.getPropertyValues("displayName");
            if (displayName.length > 0) {
                fullName.append(displayName[0]);
            } else {
                String[] fn = this.getPropertyValues("givenName");
                String[] ln = this.getPropertyValues("sn");
                if (fn.length > 0) {
                    fullName.append(fn[0]);
                }
                if (ln.length > 0) {
                    if (fullName.length() > 0) {
                        fullName.append(" ");
                    }
                    fullName.append(ln[0]);
                }
            }
            this.setFullName(fullName.toString());
            this.fetchedName = true;
        }
    }

    protected void processEmail() {
        if (!this.fetchedEmail) {
            String[] email = this.getPropertyValues("mail");
            if (email.length > 0) {
                this.setEmail(email[0]);
            } else {
                this.setEmail("");
            }
            this.fetchedEmail = true;
        }
    }

    protected String[] getPropertyValues(String key) {
        if (this.principal == null) {
            this.fetchPrincipal();
        }
        if (this.principal != null) {
            SOAPAttribute[] attributes = this.principal.getAttributes();
            for (int i = 0; i < attributes.length; ++i) {
                if (!attributes[i].getName().equals(key)) continue;
                return attributes[i].getValues();
            }
        }
        return new String[0];
    }

    protected void fetchPrincipal() {
        try {
            if (this.principal == null) {
                try {
                    this.principal = this.getCacheManager().getPrincipal(this.name);
                }
                catch (CacheException e) {
                    this.principal = this.securityServerClient.findPrincipalByName(this.name);
                    this.getCacheManager().cachePrincipal(this.principal);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)e.getMessage(), (Throwable)e);
        }
    }
}

