/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.UserDetails;
import org.apache.commons.lang.StringUtils;

public class CrowdUserDetails
implements UserDetails {
    private SOAPPrincipal principal;
    private final SecurityServerClient securityServerClient;

    public CrowdUserDetails(SOAPPrincipal principal, SecurityServerClient securityServerClient) {
        this.principal = principal;
        this.securityServerClient = securityServerClient;
    }

    public GrantedAuthority[] getAuthorities() {
        try {
            String[] groups = this.securityServerClient.findGroupMemberships(this.principal.getName());
            GrantedAuthority[] auths = new GrantedAuthority[groups.length];
            for (int i = 0; i < groups.length; ++i) {
                auths[i] = new GrantedAuthorityImpl(groups[i]);
            }
            return auths;
        }
        catch (Exception e) {
            return new GrantedAuthority[0];
        }
    }

    public String getPassword() {
        throw new UnsupportedOperationException("Not giving you the password");
    }

    public String getUsername() {
        return this.principal.getName();
    }

    public boolean isAccountNonExpired() {
        return true;
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.principal.isActive();
    }

    public String getFirstName() {
        return this.getFirstAttributeValue("givenName", this.principal);
    }

    public String getLastName() {
        return this.getFirstAttributeValue("sn", this.principal);
    }

    public String getEmail() {
        return this.getFirstAttributeValue("mail", this.principal);
    }

    public String getAttribute(String attributeName) {
        return this.getFirstAttributeValue(attributeName, this.principal);
    }

    private String getFirstAttributeValue(String name, SOAPPrincipal principal) {
        SOAPAttribute attribute = this.getAttribute(name, principal);
        if (attribute != null && attribute.getValues() != null && attribute.getValues().length > 0) {
            return attribute.getValues()[0];
        }
        return null;
    }

    private SOAPAttribute getAttribute(String name, SOAPPrincipal principal) {
        SOAPAttribute[] attributes = principal.getAttributes();
        if (attributes != null) {
            for (SOAPAttribute attribute : attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
        }
        return null;
    }

    public String getFullName() {
        String displayName = this.getFirstAttributeValue("displayName", this.principal);
        if (!StringUtils.isEmpty((String)displayName)) {
            return displayName;
        }
        return this.getFirstAttributeValue("givenName", this.principal) + " " + this.getFirstAttributeValue("sn", this.principal);
    }
}

