/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.acegi;

import com.atlassian.crowd.integration.authentication.ValidationFactor;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.http.HttpAuthenticator;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import org.acegisecurity.ui.WebAuthenticationDetails;

public class CrowdAuthenticationDetails
extends WebAuthenticationDetails {
    private String token;
    private ValidationFactor[] validationFactors;
    private final HttpAuthenticator httpAuthenticator;

    public CrowdAuthenticationDetails(HttpServletRequest request, HttpAuthenticator httpAuthenticator) {
        super(request);
        this.httpAuthenticator = httpAuthenticator;
        this.doPopulateCrowdInformation(request);
    }

    protected void doPopulateCrowdInformation(HttpServletRequest request) {
        this.validationFactors = this.httpAuthenticator.getValidationFactors(request);
        try {
            this.token = this.httpAuthenticator.getToken(request);
        }
        catch (InvalidTokenException e) {
            this.token = null;
        }
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ValidationFactor[] getValidationFactors() {
        return this.validationFactors;
    }

    public String toString() {
        return this.token;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CrowdAuthenticationDetails that = (CrowdAuthenticationDetails)((Object)o);
        if (this.token != null ? !this.token.equals(that.token) : that.token != null) {
            return false;
        }
        return Arrays.equals(this.validationFactors, that.validationFactors);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.token != null ? this.token.hashCode() : 0);
        result = 31 * result + (this.validationFactors != null ? Arrays.hashCode(this.validationFactors) : 0);
        return result;
    }
}

