/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.client;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.BulkAddFailedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidGroupException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.integration.authentication.AuthenticatedToken;
import com.atlassian.crowd.integration.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.integration.exception.InactiveAccountException;
import com.atlassian.crowd.integration.exception.InvalidCredentialException;
import com.atlassian.crowd.integration.exception.InvalidEmailAddressException;
import com.atlassian.crowd.integration.exception.InvalidRoleException;
import com.atlassian.crowd.integration.exception.InvalidTokenException;
import com.atlassian.crowd.integration.exception.InvalidUserException;
import com.atlassian.crowd.integration.exception.ObjectNotFoundException;
import com.atlassian.crowd.integration.soap.SOAPAttribute;
import com.atlassian.crowd.integration.soap.SOAPCookieInfo;
import com.atlassian.crowd.integration.soap.SOAPGroup;
import com.atlassian.crowd.integration.soap.SOAPNestableGroup;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.integration.soap.SOAPPrincipalWithCredential;
import com.atlassian.crowd.integration.soap.SOAPRole;
import com.atlassian.crowd.integration.soap.SearchRestriction;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.CleaningHttpMessageSender;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import com.atlassian.crowd.service.soap.server.SecurityServer;
import com.atlassian.crowd.service.soap.xfire.XFireFaultLoggingMethodHandler;
import com.atlassian.crowd.service.soap.xfire.XFireInLoggingMethodHandler;
import com.atlassian.crowd.service.soap.xfire.XFireOutLoggingMethodHandler;
import com.atlassian.crowd.util.SoapExceptionTranslator;
import com.atlassian.crowd.util.SoapObjectTranslator;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.codehaus.xfire.XFireFactory;
import org.codehaus.xfire.client.Client;
import org.codehaus.xfire.client.XFireProxy;
import org.codehaus.xfire.client.XFireProxyFactory;
import org.codehaus.xfire.handler.Handler;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.util.dom.DOMInHandler;
import org.codehaus.xfire.util.dom.DOMOutHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityServerClientImpl
implements SecurityServerClient {
    private static final String SHOULD_NOT_REACH_HERE_MSG = "Should not reach here.";
    private static final Logger logger = Logger.getLogger(SecurityServerClientImpl.class);
    private static final String USER_AGENT = "Mozilla/5.0 (Crowd Client 2.2.9; XFire Client)";
    protected AuthenticatedToken applicationToken;
    protected Service service;
    protected XFireProxyFactory factory;
    private final SoapClientProperties clientProperties;

    public SecurityServerClientImpl(SoapClientProperties clientProperties) {
        this.clientProperties = clientProperties;
    }

    protected SecurityServer getSecurityServer() throws RemoteException {
        try {
            if (this.service == null) {
                this.service = new ObjectServiceFactory(XFireFactory.newInstance().getXFire().getTransportManager()).create(SecurityServer.class, "SecurityServer", "urn:SecurityServer", null);
                this.service.addInHandler((Handler)new DOMInHandler());
                this.service.addOutHandler((Handler)new DOMOutHandler());
                this.service.addFaultHandler((Handler)new DOMOutHandler());
                this.service.addInHandler((Handler)new XFireInLoggingMethodHandler());
                this.service.addOutHandler((Handler)new XFireOutLoggingMethodHandler());
                this.service.addFaultHandler((Handler)new XFireFaultLoggingMethodHandler());
                this.service.setProperty("messageSender.className", (Object)CleaningHttpMessageSender.class.getName());
            }
            if (this.factory == null) {
                this.factory = new XFireProxyFactory();
            }
            logger.debug((Object)("Connection URL: " + this.clientProperties.getSecurityServerURL()));
            SecurityServer securityServer = (SecurityServer)this.factory.create(this.service, this.clientProperties.getSecurityServerURL());
            Client client = ((XFireProxy)Proxy.getInvocationHandler(securityServer)).getClient();
            client.setProperty("gzip.response.enabled", (Object)Boolean.TRUE);
            HashMap<String, String> headers = new HashMap<String, String>(1);
            headers.put("User-Agent", USER_AGENT);
            client.setProperty("http.custom.headers.map", headers);
            if (this.clientProperties.getHttpProxyHost() != null && this.clientProperties.getHttpProxyPort() != null) {
                client.setProperty("http.proxyHost", (Object)this.clientProperties.getHttpProxyHost());
                client.setProperty("http.proxyPort", (Object)this.clientProperties.getHttpProxyPort());
                if (this.clientProperties.getHttpProxyUsername() != null && this.clientProperties.getHttpProxyPassword() != null) {
                    client.setProperty("http.proxy.user", (Object)this.clientProperties.getHttpProxyUsername());
                    client.setProperty("http.proxy.password", (Object)this.clientProperties.getHttpProxyPassword());
                }
            }
            if (this.clientProperties.getHttpMaxConnections() != null) {
                client.setProperty("max.total.connections", (Object)this.clientProperties.getHttpMaxConnections());
                client.setProperty("max.connections.per.host", (Object)this.clientProperties.getHttpMaxConnections());
            }
            if (this.clientProperties.getHttpTimeout() != null) {
                client.setProperty("http.timeout", (Object)this.clientProperties.getHttpTimeout());
            }
            return securityServer;
        }
        catch (Exception e) {
            String error = "Unable to connect to crowd server URL: " + this.clientProperties.getSecurityServerURL();
            logger.fatal((Object)error, (Throwable)e);
            throw new RemoteException(error, e);
        }
    }

    public com.atlassian.crowd.model.authentication.AuthenticatedToken getApplicationToken() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        return SoapObjectTranslator.fromSoapAuthenticatedToken(this.getSoapApplicationToken());
    }

    private AuthenticatedToken getSoapApplicationToken() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        if (this.applicationToken == null) {
            logger.info((Object)"Existing application token is null, authenticating ...");
            this.authenticate();
            logger.info((Object)("Using existing token: " + this.applicationToken.getToken()));
        }
        logger.debug((Object)("Using existing token: " + this.applicationToken.getToken()));
        return this.applicationToken;
    }

    @Override
    public void authenticate() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            this.applicationToken = this.getSecurityServer().authenticateApplication(SoapObjectTranslator.toSoapApplicationAuthenticationContext(this.clientProperties.getApplicationAuthenticationContext()));
            if (this.applicationToken == null) {
                throw new InvalidAuthorizationTokenException();
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String authenticatePrincipal(UserAuthenticationContext userAuthenticationContext) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, com.atlassian.crowd.exception.InactiveAccountException, com.atlassian.crowd.exception.ApplicationAccessDeniedException, ExpiredCredentialException {
        try {
            try {
                return this.getSecurityServer().authenticatePrincipal(this.getSoapApplicationToken(), SoapObjectTranslator.toSoapUserAuthenticationContext(userAuthenticationContext));
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().authenticatePrincipal(this.getSoapApplicationToken(), SoapObjectTranslator.toSoapUserAuthenticationContext(userAuthenticationContext));
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                    throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
                }
            }
        }
        catch (ApplicationAccessDeniedException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
            throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
            throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
        }
        catch (com.atlassian.crowd.integration.exception.ExpiredCredentialException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
            throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public boolean isValidToken(String principalToken, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, com.atlassian.crowd.exception.ApplicationAccessDeniedException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().isValidPrincipalToken(this.getSoapApplicationToken(), principalToken, SoapObjectTranslator.toSoapValidationFactors(validationFactors));
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    try {
                        this.authenticate();
                    }
                    catch (InvalidAuthenticationException e1) {
                        throw e;
                    }
                    return this.getSecurityServer().isValidPrincipalToken(this.getSoapApplicationToken(), principalToken, SoapObjectTranslator.toSoapValidationFactors(validationFactors));
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ApplicationAccessDeniedException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public void invalidateToken(String token) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().invalidatePrincipalToken(this.getSoapApplicationToken(), token);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().invalidatePrincipalToken(this.getSoapApplicationToken(), token);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
    }

    @Override
    public SOAPGroup[] searchGroups(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().searchGroups(this.getSoapApplicationToken(), searchRestrictions);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().searchGroups(this.getSoapApplicationToken(), searchRestrictions);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SOAPPrincipal[] searchPrincipals(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().searchPrincipals(this.getSoapApplicationToken(), searchRestrictions);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().searchPrincipals(this.getSoapApplicationToken(), searchRestrictions);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SOAPRole[] searchRoles(SearchRestriction[] searchRestrictions) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().searchRoles(this.getSoapApplicationToken(), searchRestrictions);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().searchRoles(this.getSoapApplicationToken(), searchRestrictions);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SOAPGroup[] findAllGroups() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchGroups(searchRestrictions);
    }

    @Override
    public SOAPRole[] findAllRoles() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchRoles(searchRestrictions);
    }

    @Override
    public SOAPPrincipal[] findAllPrincipals() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        SearchRestriction[] searchRestrictions = new SearchRestriction[]{};
        return this.searchPrincipals(searchRestrictions);
    }

    @Override
    public SOAPGroup addGroup(SOAPGroup group) throws RemoteException, InvalidGroupException, InvalidAuthorizationTokenException, ApplicationPermissionException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().addGroup(this.getSoapApplicationToken(), group);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().addGroup(this.getSoapApplicationToken(), group);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidGroupException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public void updateGroup(String group, String description, boolean active) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, ApplicationPermissionException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().updateGroup(this.getSoapApplicationToken(), group, description, active);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().updateGroup(this.getSoapApplicationToken(), group, description, active);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public SOAPGroup findGroupByName(String name) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findGroupByName(this.getSoapApplicationToken(), name);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findGroupByName(this.getSoapApplicationToken(), name);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPGroup findGroupWithAttributesByName(String name) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findGroupWithAttributesByName(this.getSoapApplicationToken(), name);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findGroupWithAttributesByName(this.getSoapApplicationToken(), name);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPRole addRole(SOAPRole role) throws RemoteException, InvalidAuthorizationTokenException, com.atlassian.crowd.exception.InvalidRoleException, ApplicationPermissionException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().addRole(this.getSoapApplicationToken(), role);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().addRole(this.getSoapApplicationToken(), role);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidRoleException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPRole findRoleByName(String name) throws RemoteException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findRoleByName(this.getSoapApplicationToken(), name);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findRoleByName(this.getSoapApplicationToken(), name);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPPrincipal findPrincipalByToken(String key) throws RemoteException, com.atlassian.crowd.exception.InvalidTokenException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findPrincipalByToken(this.getSoapApplicationToken(), key);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findPrincipalByToken(this.getSoapApplicationToken(), key);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (InvalidTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public void updatePrincipalAttribute(String name, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().updatePrincipalAttribute(this.getSoapApplicationToken(), name, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().updatePrincipalAttribute(this.getSoapApplicationToken(), name, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void updateGroupAttribute(String name, SOAPAttribute attribute) throws RemoteException, ApplicationPermissionException, InvalidAuthorizationTokenException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().updateGroupAttribute(this.getSoapApplicationToken(), name, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().updateGroupAttribute(this.getSoapApplicationToken(), name, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public SOAPPrincipal findPrincipalByName(String name) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findPrincipalByName(this.getSoapApplicationToken(), name);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findPrincipalByName(this.getSoapApplicationToken(), name);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPPrincipal findPrincipalWithAttributesByName(String name) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findPrincipalWithAttributesByName(this.getSoapApplicationToken(), name);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findPrincipalWithAttributesByName(this.getSoapApplicationToken(), name);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public SOAPPrincipal addPrincipal(SOAPPrincipal principal, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, com.atlassian.crowd.exception.InvalidCredentialException, com.atlassian.crowd.exception.InvalidUserException, ApplicationPermissionException, InvalidAuthenticationException {
        try {
            com.atlassian.crowd.integration.authentication.PasswordCredential cred = new com.atlassian.crowd.integration.authentication.PasswordCredential(credential.getCredential(), credential.isEncryptedCredential());
            try {
                return this.getSecurityServer().addPrincipal(this.getSoapApplicationToken(), principal, cred);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                return this.getSecurityServer().addPrincipal(this.getSoapApplicationToken(), principal, cred);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidCredentialException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidUserException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public void addAllPrincipals(Collection<SOAPPrincipalWithCredential> principals) throws InvalidAuthorizationTokenException, RemoteException, ApplicationPermissionException, BulkAddFailedException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().addAllPrincipals(this.getSoapApplicationToken(), principals.toArray(new SOAPPrincipalWithCredential[principals.size()]));
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().addAllPrincipals(this.getSoapApplicationToken(), principals.toArray(new SOAPPrincipalWithCredential[principals.size()]));
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.BulkAddFailedException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
    }

    @Override
    public void addPrincipalToGroup(String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().addPrincipalToGroup(this.getSoapApplicationToken(), principal, group);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().addPrincipalToGroup(this.getSoapApplicationToken(), principal, group);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void updatePrincipalCredential(String principal, PasswordCredential credential) throws RemoteException, InvalidAuthorizationTokenException, com.atlassian.crowd.exception.InvalidCredentialException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException {
        try {
            com.atlassian.crowd.integration.authentication.PasswordCredential cred = new com.atlassian.crowd.integration.authentication.PasswordCredential(credential.getCredential(), credential.isEncryptedCredential());
            try {
                this.getSecurityServer().updatePrincipalCredential(this.getSoapApplicationToken(), principal, cred);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().updatePrincipalCredential(this.getSoapApplicationToken(), principal, cred);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidCredentialException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void resetPrincipalCredential(String principal) throws RemoteException, com.atlassian.crowd.exception.InvalidEmailAddressException, com.atlassian.crowd.exception.InvalidCredentialException, ApplicationPermissionException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().resetPrincipalCredential(this.getSoapApplicationToken(), principal);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().resetPrincipalCredential(this.getSoapApplicationToken(), principal);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidEmailAddressException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InvalidCredentialException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void removeGroup(String group) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removeGroup(this.getSoapApplicationToken(), group);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removeGroup(this.getSoapApplicationToken(), group);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public void removeRole(String role) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removeRole(this.getSoapApplicationToken(), role);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removeRole(this.getSoapApplicationToken(), role);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public void removePrincipal(String principal) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removePrincipal(this.getSoapApplicationToken(), principal);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removePrincipal(this.getSoapApplicationToken(), principal);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void addPrincipalToRole(String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().addPrincipalToRole(this.getSoapApplicationToken(), principal, role);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().addPrincipalToRole(this.getSoapApplicationToken(), principal, role);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserOrGroupNotFoundException(e);
        }
    }

    @Override
    public boolean isGroupMember(String group, String principal) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().isGroupMember(this.getSoapApplicationToken(), group, principal);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().isGroupMember(this.getSoapApplicationToken(), group, principal);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public boolean isRoleMember(String role, String principal) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().isRoleMember(this.getSoapApplicationToken(), role, principal);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().isRoleMember(this.getSoapApplicationToken(), role, principal);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public void removePrincipalFromGroup(String principal, String group) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removePrincipalFromGroup(this.getSoapApplicationToken(), principal, group);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removePrincipalFromGroup(this.getSoapApplicationToken(), principal, group);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserOrGroupOrMembershipNotFoundException(e);
        }
    }

    @Override
    public void removePrincipalFromRole(String principal, String role) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, GroupNotFoundException, MembershipNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removePrincipalFromRole(this.getSoapApplicationToken(), principal, role);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removePrincipalFromRole(this.getSoapApplicationToken(), principal, role);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserOrGroupOrMembershipNotFoundException(e);
        }
    }

    @Override
    public void addAttributeToPrincipal(String principal, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().addAttributeToPrincipal(this.getSoapApplicationToken(), principal, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().addAttributeToPrincipal(this.getSoapApplicationToken(), principal, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void removeAttributeFromPrincipal(String principal, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removeAttributeFromPrincipal(this.getSoapApplicationToken(), principal, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removeAttributeFromPrincipal(this.getSoapApplicationToken(), principal, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
    }

    @Override
    public void addAttributeToGroup(String group, SOAPAttribute attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().addAttributeToGroup(this.getSoapApplicationToken(), group, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().addAttributeToGroup(this.getSoapApplicationToken(), group, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public void removeAttributeFromGroup(String group, String attribute) throws RemoteException, InvalidAuthorizationTokenException, ApplicationPermissionException, GroupNotFoundException, InvalidAuthenticationException {
        try {
            try {
                this.getSecurityServer().removeAttributeFromGroup(this.getSoapApplicationToken(), group, attribute);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                this.authenticate();
                this.getSecurityServer().removeAttributeFromGroup(this.getSoapApplicationToken(), group, attribute);
            }
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ApplicationPermissionException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentGroupNotFoundException(e);
        }
    }

    @Override
    public long getCacheTime() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().getCacheTime(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().getCacheTime(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public boolean isCacheEnabled() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().isCacheEnabled(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().isCacheEnabled(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public String getDomain() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().getDomain(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().getDomain(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public String[] findAllPrincipalNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().findAllPrincipalNames(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().findAllPrincipalNames(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public String[] findAllGroupNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().findAllGroupNames(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().findAllGroupNames(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SOAPNestableGroup[] findAllGroupRelationships() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().findAllGroupRelationships(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().findAllGroupRelationships(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public String[] findAllRoleNames() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().findAllRoleNames(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().findAllRoleNames(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public String[] findGroupMemberships(String principalName) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findGroupMemberships(this.getSoapApplicationToken(), principalName);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findGroupMemberships(this.getSoapApplicationToken(), principalName);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public String[] findRoleMemberships(String principalName) throws RemoteException, InvalidAuthorizationTokenException, UserNotFoundException, InvalidAuthenticationException {
        try {
            try {
                return this.getSecurityServer().findRoleMemberships(this.getSoapApplicationToken(), principalName);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().findRoleMemberships(this.getSoapApplicationToken(), principalName);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ObjectNotFoundException e) {
            SoapExceptionTranslator.throwEquivalentUserNotFoundException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public String authenticatePrincipalSimple(String username, String password) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, com.atlassian.crowd.exception.InactiveAccountException, com.atlassian.crowd.exception.ApplicationAccessDeniedException, ExpiredCredentialException {
        try {
            try {
                return this.getSecurityServer().authenticatePrincipalSimple(this.getSoapApplicationToken(), username, password);
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().authenticatePrincipalSimple(this.getSoapApplicationToken(), username, password);
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ApplicationAccessDeniedException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.ExpiredCredentialException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public String createPrincipalToken(String username, ValidationFactor[] validationFactors) throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException, com.atlassian.crowd.exception.InactiveAccountException, com.atlassian.crowd.exception.ApplicationAccessDeniedException {
        try {
            try {
                return this.getSecurityServer().createPrincipalToken(this.getSoapApplicationToken(), username, SoapObjectTranslator.toSoapValidationFactors(validationFactors));
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
                try {
                    this.authenticate();
                    return this.getSecurityServer().createPrincipalToken(this.getSoapApplicationToken(), username, SoapObjectTranslator.toSoapValidationFactors(validationFactors));
                }
                catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                    SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                }
            }
        }
        catch (ApplicationAccessDeniedException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (InactiveAccountException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthenticationException e) {
            SoapExceptionTranslator.throwEquivalentCheckedException(e);
        }
        throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
    }

    @Override
    public String[] getGrantedAuthorities() throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().getGrantedAuthorities(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().getGrantedAuthorities(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SOAPCookieInfo getCookieInfo() throws RemoteException, InvalidAuthorizationTokenException, InvalidAuthenticationException {
        try {
            return this.getSecurityServer().getCookieInfo(this.getSoapApplicationToken());
        }
        catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e) {
            try {
                this.authenticate();
                return this.getSecurityServer().getCookieInfo(this.getSoapApplicationToken());
            }
            catch (com.atlassian.crowd.integration.exception.InvalidAuthorizationTokenException e2) {
                SoapExceptionTranslator.throwEquivalentCheckedException(e2);
                throw new AssertionError((Object)SHOULD_NOT_REACH_HERE_MSG);
            }
        }
    }

    @Override
    public SoapClientProperties getSoapClientProperties() {
        return this.clientProperties;
    }
}

