/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.http;

import com.atlassian.crowd.exception.ApplicationAccessDeniedException;
import com.atlassian.crowd.exception.ExpiredCredentialException;
import com.atlassian.crowd.exception.InactiveAccountException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.InvalidAuthorizationTokenException;
import com.atlassian.crowd.exception.InvalidTokenException;
import com.atlassian.crowd.integration.soap.SOAPPrincipal;
import com.atlassian.crowd.model.authentication.UserAuthenticationContext;
import com.atlassian.crowd.model.authentication.ValidationFactor;
import com.atlassian.crowd.service.soap.client.SecurityServerClient;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import java.rmi.RemoteException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public interface HttpAuthenticator {
    public SoapClientProperties getSoapClientProperties();

    public SecurityServerClient getSecurityServerClient();

    public void setPrincipalToken(HttpServletRequest var1, HttpServletResponse var2, String var3) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException;

    public SOAPPrincipal getPrincipal(HttpServletRequest var1) throws InvalidAuthorizationTokenException, RemoteException, InvalidTokenException, InvalidAuthenticationException;

    public String getToken(HttpServletRequest var1) throws InvalidTokenException;

    public boolean isAuthenticated(HttpServletRequest var1, HttpServletResponse var2) throws InvalidAuthorizationTokenException, RemoteException, ApplicationAccessDeniedException, InvalidAuthenticationException;

    public void authenticate(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public void authenticateWithoutValidatingPassword(HttpServletRequest var1, HttpServletResponse var2, String var3) throws ApplicationAccessDeniedException, InvalidAuthenticationException, InvalidAuthorizationTokenException, InactiveAccountException, RemoteException;

    public String verifyAuthentication(String var1, String var2, ValidationFactor[] var3) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public void verifyAuthentication(String var1, String var2) throws InvalidAuthorizationTokenException, InvalidAuthenticationException, RemoteException, InactiveAccountException, ApplicationAccessDeniedException, ExpiredCredentialException;

    public ValidationFactor[] getValidationFactors(HttpServletRequest var1);

    public void logoff(HttpServletRequest var1, HttpServletResponse var2) throws InvalidAuthorizationTokenException, RemoteException, InvalidAuthenticationException;

    public UserAuthenticationContext getPrincipalAuthenticationContext(HttpServletRequest var1, HttpServletResponse var2, String var3, String var4);
}

