/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.service.soap.client;

import com.atlassian.crowd.service.client.ClientPropertiesImpl;
import com.atlassian.crowd.service.client.ResourceLocator;
import com.atlassian.crowd.service.soap.client.SoapClientProperties;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class SoapClientPropertiesImpl
extends ClientPropertiesImpl
implements SoapClientProperties {
    public static final String PROPERTIES_FILE_SECURITY_SERVER_URL = "crowd.server.url";
    private final Logger logger = Logger.getLogger(this.getClass());
    private String securityServerURL = null;

    private SoapClientPropertiesImpl() {
    }

    public void updateProperties(Properties properties) {
        super.updateProperties(properties);
        this.setSecurityServerURL(this.loadAndLogPropertyString(properties, PROPERTIES_FILE_SECURITY_SERVER_URL));
    }

    public String getSecurityServerURL() {
        return this.securityServerURL;
    }

    private void setSecurityServerURL(String url) {
        this.securityServerURL = (url = StringUtils.removeEnd((String)url, (String)"/")) != null ? (url.endsWith("SecurityServer") ? url : (url.endsWith("services") ? url + "/" + "SecurityServer" : url + "/" + "services" + "/" + "SecurityServer")) : url;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClientPropertiesImpl");
        sb.append("{applicationName='").append(this.getApplicationName()).append('\'');
        sb.append(", applicationPassword='").append(this.getApplicationPassword()).append('\'');
        sb.append(", applicationAuthenticationURL='").append(this.getApplicationAuthenticationURL()).append('\'');
        sb.append(", securityServerURL='").append(this.securityServerURL).append('\'');
        sb.append(", cookieTokenKey='").append(this.getCookieTokenKey()).append('\'');
        sb.append(", sessionTokenKey='").append(this.getSessionTokenKey()).append('\'');
        sb.append(", sessionLastValidation='").append(this.getSessionLastValidation()).append('\'');
        sb.append(", sessionValidationInterval=").append(this.getSessionValidationInterval());
        sb.append(", baseURL='").append(this.getBaseURL()).append('\'');
        sb.append(", httpProxyPort='").append(this.getHttpProxyPort()).append('\'');
        sb.append(", httpProxyHost='").append(this.getHttpProxyHost()).append('\'');
        sb.append(", httpProxyUsername='").append(this.getHttpProxyUsername()).append('\'');
        sb.append(", httpProxyPassword='").append(this.getHttpProxyPassword()).append('\'');
        sb.append(", httpMaxConnections='").append(this.getHttpMaxConnections()).append('\'');
        sb.append(", httpTimeout='").append(this.getHttpTimeout()).append('\'');
        sb.append(", applicationAuthenticationContext=").append(this.getApplicationAuthenticationContext());
        sb.append('}');
        return sb.toString();
    }

    public static SoapClientPropertiesImpl newInstanceFromResourceLocator(ResourceLocator resourceLocator) {
        Properties properties = resourceLocator.getProperties();
        return SoapClientPropertiesImpl.newInstanceFromProperties(properties);
    }

    public static SoapClientPropertiesImpl newInstanceFromProperties(Properties properties) {
        SoapClientPropertiesImpl clientProperties = new SoapClientPropertiesImpl();
        clientProperties.updateProperties(properties);
        return clientProperties;
    }
}

