/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.integration.xwork;

import com.atlassian.crowd.integration.http.HttpAuthenticator;
import com.atlassian.crowd.integration.http.HttpAuthenticatorFactory;
import com.opensymphony.xwork2.ActionInvocation;
import com.opensymphony.xwork2.interceptor.Interceptor;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts2.ServletActionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrowdAuthenticationInterceptor
implements Interceptor {
    private static final Logger logger = LoggerFactory.getLogger(CrowdAuthenticationInterceptor.class);
    public static final String ORIGINAL_URL = CrowdAuthenticationInterceptor.class.getName() + ".ORIGINAL_URL";
    private final HttpAuthenticator httpAuthenticator;

    public CrowdAuthenticationInterceptor() {
        this(HttpAuthenticatorFactory.getHttpAuthenticator());
    }

    public CrowdAuthenticationInterceptor(HttpAuthenticator httpAuthenticator) {
        this.httpAuthenticator = httpAuthenticator;
    }

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        HttpServletRequest request = ServletActionContext.getRequest();
        HttpServletResponse response = ServletActionContext.getResponse();
        boolean isValidated = this.httpAuthenticator.isAuthenticated(request, response);
        StringBuffer originalURL = request.getRequestURL();
        boolean foundParameter = false;
        if (request.getParameterMap().size() > 0) {
            originalURL.append("?");
            Enumeration params = request.getParameterNames();
            while (params.hasMoreElements()) {
                if (!foundParameter) {
                    foundParameter = true;
                } else {
                    originalURL.append("&");
                }
                String name = (String)params.nextElement();
                String[] values = request.getParameterValues(name);
                for (int i = 0; i < values.length; ++i) {
                    originalURL.append(name + "=" + values[i]);
                }
            }
        }
        if (!isValidated) {
            logger.debug("Requesting URL is: " + originalURL);
            request.getSession().setAttribute(ORIGINAL_URL, (Object)originalURL.toString());
            String applicationAuthenticationURL = this.httpAuthenticator.getSoapClientProperties().getApplicationAuthenticationURL();
            logger.info("Authentication is not valid, redirecting to: " + applicationAuthenticationURL);
            response.sendRedirect(applicationAuthenticationURL);
        } else {
            request.removeAttribute(ORIGINAL_URL);
        }
        return actionInvocation.invoke();
    }
}

